/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import org.slf4j.Logger;

public class DebugLogger {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEBUG = DebugLogger.isDebugOn();

    private static boolean isDebugOn() {
        boolean debug = false;
        try {
            debug = Objects.equals(System.getenv("IS_DEBUG"), "TRUE");
            if (debug) {
                LOGGER.info("Debug logging enabled");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return debug;
    }

    public static boolean isDebugEnabled() {
        return IS_DEBUG;
    }

    public static void debug(String msg) {
        if (IS_DEBUG) {
            LOGGER.debug(msg);
        }
    }

    public static void info(String msg) {
        LOGGER.info(msg);
    }

    public static void warn(String msg) {
        LOGGER.warn(msg);
    }

    public static void error(String msg) {
        LOGGER.error(msg);
    }

    public static void error(String msg, Throwable t) {
        LOGGER.error(msg, t);
    }
}

