/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="pop_up_emotes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue allowCustomPacks;
    private static final ForgeConfigSpec.BooleanValue allowImagePacks;
    private static final ForgeConfigSpec.BooleanValue allowUrlPacks;
    public static ForgeConfigSpec.IntValue maxEmoteAmount;
    public static ForgeConfigSpec.IntValue maxPackSizeMB;
    public static ForgeConfigSpec.BooleanValue lowNetworkUsage;
    public static ForgeConfigSpec.IntValue maxPacketsPerTick;
    public static ForgeConfigSpec.IntValue maxPacketsPerTickPerPlayer;

    public static int getEmoteMode() {
        if (!((Boolean)allowCustomPacks.get()).booleanValue()) {
            return -1;
        }
        if (((Boolean)allowUrlPacks.get()).booleanValue() && ((Boolean)allowImagePacks.get()).booleanValue()) {
            return 1;
        }
        if (((Boolean)allowUrlPacks.get()).booleanValue()) {
            return 1;
        }
        if (((Boolean)allowImagePacks.get()).booleanValue()) {
            return 2;
        }
        return -1;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        BUILDER.comment("Pop-up Emotes Server Config");
        BUILDER.push("data_1_3_6");
        BUILDER.comment("Allow clients to upload their custom emote packs.");
        allowCustomPacks = BUILDER.define("allowCustomPacks", true);
        BUILDER.comment("Allow clients to send their emotes as url links. Takes priority over 'allowImagePacks'.");
        allowUrlPacks = BUILDER.define("allowUrlPacks", true);
        BUILDER.comment("Ignored if allowUrlPacks is true.Allow clients to send their emotes as images (from pop_emote_pack) to the server.\nThis might be resource expensive on servers with more than 10 concurrent people.\nLike imagine 11th player enters with 6MB emote pack - that's 66MB of traffic. And players leave/enter all the time.\nI'd use it only for small servers.");
        allowImagePacks = BUILDER.define("allowImagePacks", false);
        BUILDER.comment("The maximum received per-player emote amount.");
        maxEmoteAmount = BUILDER.defineInRange("maxEmoteAmount", 24, 8, 40);
        BUILDER.comment("The maximum received per-player emote pack size, measured in megabytes.");
        maxPackSizeMB = BUILDER.defineInRange("maxPackSizeMB", 8, 1, 32);
        BUILDER.comment("If you have low internet bandwidth and are unsure how to adjust maxPacketsPerTick, enable this option. It limits max bandwidth used when sending/receiving emotes to ~640 KB/sec.");
        lowNetworkUsage = BUILDER.define("lowNetworkUsage", false);
        BUILDER.comment("Custom limit for emote pack chunk packets sent per tick. These packets are sent to players when they join the server. Reduce this value if the server has low bandwidth to balance usage.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet/tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 8 packets per tick (~2.5MB/sec).");
        maxPacketsPerTick = BUILDER.defineInRange("maxPacketsPerTick", 4, 1, 16);
        BUILDER.comment("*Per Player* Custom limit for emote pack chunk packets sent per tick. These packets are sent to player when they join the server.\nThe server runs at 20 ticks per second.\n1 emote chunk packet \u2248 32KB.\nAt 1 packet/tick: 20 packets/sec \u2248 640KB/sec.\nDefault: 1 packets per tick (~640/sec).");
        maxPacketsPerTickPerPlayer = BUILDER.defineInRange("maxPacketsPerTickPerPlayer", 2, 1, 16);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

