/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPacket;
import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEmoteChunkScheduler {
    public static int maxPacketsPerTick = 10;
    private static final ArrayDeque<EmotePackChunkToServerPacket> queue = new ArrayDeque();

    public static void schedule(EmotePackChunkToServerPacket packet) {
        queue.add(packet);
    }

    public static boolean isSending() {
        return !queue.isEmpty();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().m_91403_() == null) {
            return;
        }
        if (queue.isEmpty()) {
            return;
        }
        for (int i = 0; i < maxPacketsPerTick && !queue.isEmpty(); ++i) {
            EmotePackChunkToServerPacket packet = queue.poll();
            NetworkHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        queue.clear();
    }
}

