/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.DebugLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientEmotePacksManager {
    public static final ResourceLocation[] DEFAULT_EMOTE_PACK;
    public static int serverEmoteMode;
    private static final Map<UUID, Map<Integer, byte[]>> cachedEmotePacks;
    @Nullable
    private static Map<Integer, byte[]> cachedLocalEmotePack;
    @Nullable
    private static Map<Integer, byte[]> cachedDefaultEmoteBytes;
    private static final Map<Integer, String> cachedLocalEmotePackUrls;
    public static int MAX_PACK_SIZE_BYTES;
    public static int MAX_PACK_EMOTE_AMOUNT;
    private static final Map<UUID, Map<Integer, String>> playerEmoteUrls;
    private static final ExecutorService urlDownloader;
    public static boolean lastLoadEncounterOversize;
    public static volatile boolean downloadingLocalPlayerUrls;
    private static final UUID decoyUUID;
    public static Map<UUID, Map<Integer, ChunkBuffer>> chunkBuffers;
    public static volatile Set<String> lastDownloadFailLocalUrls;

    public static List<String> getLocalEmoteUrls() {
        return cachedLocalEmotePackUrls.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
    }

    @Nullable
    public static Map<Integer, byte[]> getLocalEmotePack() {
        if (downloadingLocalPlayerUrls) {
            DebugLogger.debug("getLocalEmotePack: Already downloading");
            return null;
        }
        if (cachedLocalEmotePack != null && !cachedLocalEmotePack.isEmpty()) {
            return cachedLocalEmotePack;
        }
        if (!((List)ClientConfig.emotePackUrls.get()).isEmpty()) {
            ClientEmotePacksManager.downloadLocalPlayerUrlEmotes();
            return null;
        }
        Map<Integer, byte[]> fromDisk = ClientEmotePacksManager.loadLocalEmotePack();
        if (!fromDisk.isEmpty()) {
            cachedLocalEmotePack = fromDisk;
            return fromDisk;
        }
        return cachedLocalEmotePack;
    }

    public static void downloadLocalPlayerUrlEmotes() {
        List urls = (List)ClientConfig.emotePackUrls.get();
        if (urls.isEmpty()) {
            return;
        }
        ClientEmotePacksManager.cachePlayerEmoteUrls(decoyUUID, urls);
    }

    public static int emotesAmount() {
        int min = DEFAULT_EMOTE_PACK.length;
        int local = 0;
        if (cachedLocalEmotePack != null) {
            local = cachedLocalEmotePack.size();
        }
        return Math.max(min, local);
    }

    public static int localEmotesAmount() {
        if (cachedLocalEmotePack != null) {
            return cachedLocalEmotePack.size();
        }
        return 0;
    }

    public static boolean hasCustomEmotes() {
        return ClientEmotePacksManager.localEmotesAmount() > 0;
    }

    public static boolean isCustomEmotesCacheBuilt() {
        return cachedLocalEmotePack != null;
    }

    public static void clearCache() {
        cachedEmotePacks.clear();
        cachedLocalEmotePack = null;
        cachedDefaultEmoteBytes = null;
    }

    public static void recreateCache() {
        ClientEmotePacksManager.clearCache();
        ClientEmotePacksManager.getLocalEmotePack();
        ClientEmotePacksManager.loadDefaultEmotesAsBytes();
    }

    private static Map<Integer, byte[]> loadLocalEmotePack() {
        lastLoadEncounterOversize = false;
        LinkedHashMap<Integer, byte[]> emotesMap = new LinkedHashMap<Integer, byte[]>();
        try {
            Path baseFolder = ClientEmotePacksManager.getEmotePackFolder();
            DirectoryStream.Filter<Path> filter = entry -> {
                String name = entry.getFileName().toString().toLowerCase();
                return name.endsWith(".png");
            };
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(baseFolder, filter);){
                int index = 0;
                int totalSize = 0;
                for (Path entry2 : stream) {
                    if (index >= MAX_PACK_EMOTE_AMOUNT) break;
                    try {
                        byte[] imageBytes = Files.readAllBytes(entry2);
                        NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));
                        nativeImage.close();
                        if (!DebugLogger.isDebugEnabled()) {
                            try {
                                BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
                                int width = img.getWidth();
                                int height = img.getHeight();
                                img = width > 512 || height > 512 ? Thumbnails.of(img).size(512, 512).keepAspectRatio(true).asBufferedImage() : Thumbnails.of(img).size(width, height).keepAspectRatio(true).useOriginalFormat().outputQuality(0.0f).asBufferedImage();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                ImageIO.write((RenderedImage)img, "png", baos);
                                imageBytes = baos.toByteArray();
                            }
                            catch (Exception e) {
                                DebugLogger.error("Resize error: ", e);
                            }
                        }
                        if (totalSize + imageBytes.length > MAX_PACK_SIZE_BYTES) {
                            lastLoadEncounterOversize = true;
                            System.err.println("[Pop-up Emotes] Skipping " + entry2 + " because pack would exceed the " + ClientConfig.maxPackSizeMB.get() + " MB limit.");
                            break;
                        }
                        emotesMap.put(index++, imageBytes);
                        totalSize += imageBytes.length;
                    }
                    catch (IOException e) {
                        System.err.println("[Pop-up Emotes] Can't load emote image " + entry2 + ": " + e.getMessage());
                    }
                }
                if (totalSize > MAX_PACK_SIZE_BYTES) {
                    System.err.println("[Pop-up Emotes] Total emote pack size exceeds limit! Only part of it was loaded.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return emotesMap;
    }

    @NotNull
    public static Map<Integer, byte[]> loadDefaultEmotesAsBytes() {
        if (cachedDefaultEmoteBytes != null) {
            return cachedDefaultEmoteBytes;
        }
        LinkedHashMap<Integer, byte[]> map = new LinkedHashMap<Integer, byte[]>();
        for (int i = 0; i < DEFAULT_EMOTE_PACK.length; ++i) {
            byte[] bytes = ClientEmotePacksManager.readResourceTextureToBytes(DEFAULT_EMOTE_PACK[i]);
            if (bytes == null) continue;
            map.put(i, bytes);
        }
        cachedDefaultEmoteBytes = map;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readResourceTextureToBytes(ResourceLocation resourceLocation) {
        try (InputStream inputStream = Minecraft.m_91087_().m_91098_().m_215595_(resourceLocation);){
            if (inputStream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearAllChunkBuffers() {
        chunkBuffers.clear();
        cachedEmotePacks.clear();
    }

    public static void cachePlayerEmotePack(UUID playerUUID, Map<Integer, byte[]> emotes) {
        cachedEmotePacks.put(playerUUID, emotes);
        if (decoyUUID.equals(playerUUID)) {
            cachedLocalEmotePack = emotes;
        }
    }

    public static void removePlayerEmotePack(UUID playerUUID) {
        cachedEmotePacks.remove(playerUUID);
        if (decoyUUID.equals(playerUUID)) {
            cachedLocalEmotePack = null;
        }
    }

    public static Path getEmotePackFolder() {
        return Minecraft.m_91087_().f_91069_.toPath().resolve("pop_emote_pack");
    }

    public static void addChunk(UUID playerUUID, int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        chunkBuffers.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).computeIfAbsent(emoteId, k -> new ChunkBuffer(totalChunks)).addChunk(chunkIndex, chunkData);
    }

    public static boolean isEmoteComplete(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return false;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        return buffer != null && buffer.isComplete();
    }

    public static byte[] assembleEmote(UUID playerUUID, int emoteId) {
        Map<Integer, ChunkBuffer> emoteMap = chunkBuffers.get(playerUUID);
        if (emoteMap == null) {
            return null;
        }
        ChunkBuffer buffer = emoteMap.get(emoteId);
        if (buffer == null || !buffer.isComplete()) {
            return null;
        }
        byte[] emote = buffer.assemble();
        emoteMap.remove(emoteId);
        if (emoteMap.isEmpty()) {
            chunkBuffers.remove(playerUUID);
        }
        return emote;
    }

    public static void cachePlayerEmote(UUID playerUUID, int emoteId, byte[] emoteData) {
        cachedEmotePacks.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(emoteId, emoteData);
    }

    public static void cachePlayerEmoteUrls(UUID senderUUID, List<String> urls) {
        ClientEmotePacksManager.downloadEmoteImages(senderUUID, urls);
    }

    public static Map<Integer, String> getPlayerEmoteUrls(UUID playerUUID) {
        if (playerUUID.equals(decoyUUID) && !cachedLocalEmotePackUrls.isEmpty()) {
            return cachedLocalEmotePackUrls;
        }
        return playerEmoteUrls.getOrDefault(playerUUID, Map.of());
    }

    public static Map<Integer, String> getLocalPlayerEmoteUrls() {
        if (!cachedLocalEmotePackUrls.isEmpty()) {
            return cachedLocalEmotePackUrls;
        }
        return playerEmoteUrls.getOrDefault(decoyUUID, Map.of());
    }

    private static void downloadEmoteImages(UUID playerUUID, List<String> urls) {
        if (urls.isEmpty()) {
            return;
        }
        if (decoyUUID.equals(playerUUID)) {
            if (downloadingLocalPlayerUrls) {
                return;
            }
            downloadingLocalPlayerUrls = true;
            lastDownloadFailLocalUrls.clear();
            cachedLocalEmotePackUrls.clear();
        }
        CompletableFuture.runAsync(() -> {
            ConcurrentHashMap<Integer, byte[]> emoteBytes = new ConcurrentHashMap<Integer, byte[]>();
            int curEmoteId = 0;
            int totalSize = 0;
            HashMap<Integer, String> okUrls = new HashMap<Integer, String>();
            for (int i = 0; i < urls.size() && i < MAX_PACK_EMOTE_AMOUNT; ++i) {
                String url = (String)urls.get(i);
                if (!decoyUUID.equals(playerUUID)) {
                    Map<Integer, String> urls2 = playerEmoteUrls.get(playerUUID);
                    Map<Integer, byte[]> images = cachedEmotePacks.get(playerUUID);
                    if (urls2 != null && images != null && urls2.size() > i && urls2.get(i) != null && images.size() > i && images.get(i) != null) {
                        DebugLogger.debug("Skip already cached image: " + url);
                        continue;
                    }
                }
                try {
                    byte[] imageBytes = ClientEmotePacksManager.downloadImage(url);
                    if (imageBytes == null) {
                        if (!decoyUUID.equals(playerUUID)) continue;
                        lastDownloadFailLocalUrls.add(url);
                        continue;
                    }
                    if (!DebugLogger.isDebugEnabled()) {
                        imageBytes = ClientEmotePacksManager.resizeImageIfNeeded(imageBytes);
                    }
                    if (totalSize + imageBytes.length > MAX_PACK_SIZE_BYTES) {
                        DebugLogger.warn("URL emote " + i + " skipped - pack size limit");
                        break;
                    }
                    try (NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));){
                        if (decoyUUID.equals(playerUUID)) {
                            emoteBytes.put(curEmoteId, imageBytes);
                            cachedLocalEmotePackUrls.put(curEmoteId, url);
                            okUrls.put(curEmoteId, url);
                        } else {
                            emoteBytes.put(i, imageBytes);
                            okUrls.put(i, url);
                        }
                        ++curEmoteId;
                        totalSize += imageBytes.length;
                        continue;
                    }
                }
                catch (Exception e) {
                    if (decoyUUID.equals(playerUUID)) {
                        lastDownloadFailLocalUrls.add(url);
                    }
                    DebugLogger.error("Failed to process URL emote " + i + ": " + url, e);
                }
            }
            if (!emoteBytes.isEmpty()) {
                cachedEmotePacks.put(playerUUID, emoteBytes);
                playerEmoteUrls.put(playerUUID, okUrls);
                if (decoyUUID.equals(playerUUID)) {
                    cachedLocalEmotePack = emoteBytes;
                    DebugLogger.debug("Downloaded " + emoteBytes.size() + " emotes from URLs for local player");
                } else {
                    DebugLogger.debug("Downloaded " + emoteBytes.size() + " emotes from URLs for " + playerUUID);
                }
            }
            if (decoyUUID.equals(playerUUID)) {
                downloadingLocalPlayerUrls = false;
            }
        }, urlDownloader);
        DebugLogger.debug("Cached " + urls.size() + " URLs for " + playerUUID);
    }

    private static byte[] downloadImage(String urlString) throws IOException {
        byte[] byArray;
        block10: {
            if (urlString.startsWith("invalid://")) {
                DebugLogger.warn("Skipping invalid URL: " + urlString);
                return null;
            }
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "Pop-up-Emotes/1.0");
            InputStream input = conn.getInputStream();
            try {
                int bytesRead;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byArray = baos.toByteArray();
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    DebugLogger.error("Download failed: " + urlString, e);
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    private static byte[] resizeImageIfNeeded(byte[] imageBytes) throws IOException {
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
        int width = img.getWidth();
        int height = img.getHeight();
        img = width > 512 || height > 512 ? Thumbnails.of(img).size(512, 512).keepAspectRatio(true).asBufferedImage() : Thumbnails.of(img).size(width, height).keepAspectRatio(true).outputQuality(0.8).asBufferedImage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        return baos.toByteArray();
    }

    public static Map<Integer, byte[]> getPlayerEmotePack(UUID playerUUID) {
        if (decoyUUID.equals(playerUUID)) {
            return ClientEmotePacksManager.getLocalEmotePack();
        }
        Map<Integer, byte[]> urlEmotes = ClientEmotePacksManager.getPlayerUrlEmotePack(playerUUID);
        if (!urlEmotes.isEmpty()) {
            return urlEmotes;
        }
        return cachedEmotePacks.getOrDefault(playerUUID, Map.of());
    }

    private static Map<Integer, byte[]> getPlayerUrlEmotePack(UUID playerUUID) {
        Map<Integer, byte[]> emotes = cachedEmotePacks.get(playerUUID);
        return emotes != null ? emotes : Map.of();
    }

    public static void shutdown() {
        urlDownloader.shutdown();
    }

    static {
        serverEmoteMode = -1;
        int resourcePackEmoteAmount = (Integer)ClientConfig.resourcePackEmoteAmount.get();
        DEFAULT_EMOTE_PACK = new ResourceLocation[resourcePackEmoteAmount];
        String[] paths = new String[]{"textures/emotes/a_emote1.png", "textures/emotes/a_emote2.png", "textures/emotes/a_emote3.png", "textures/emotes/a_emote4.png", "textures/emotes/a_emote5.png", "textures/emotes/a_emote6.png", "textures/emotes/a_emote7.png", "textures/emotes/a_emote8.png", "textures/emotes/b_emote1.png", "textures/emotes/b_emote2.png", "textures/emotes/b_emote3.png", "textures/emotes/b_emote4.png", "textures/emotes/b_emote5.png", "textures/emotes/b_emote6.png", "textures/emotes/b_emote7.png", "textures/emotes/b_emote8.png", "textures/emotes/c_emote1.png", "textures/emotes/c_emote2.png", "textures/emotes/c_emote3.png", "textures/emotes/c_emote4.png", "textures/emotes/c_emote5.png", "textures/emotes/c_emote6.png", "textures/emotes/c_emote7.png", "textures/emotes/c_emote8.png", "textures/emotes/d_emote1.png", "textures/emotes/d_emote2.png", "textures/emotes/d_emote3.png", "textures/emotes/d_emote4.png", "textures/emotes/d_emote5.png", "textures/emotes/d_emote6.png", "textures/emotes/d_emote7.png", "textures/emotes/d_emote8.png", "textures/emotes/e_emote1.png", "textures/emotes/e_emote2.png", "textures/emotes/e_emote3.png", "textures/emotes/e_emote4.png", "textures/emotes/e_emote5.png", "textures/emotes/e_emote6.png", "textures/emotes/e_emote7.png", "textures/emotes/e_emote8.png"};
        for (int i = 0; i < resourcePackEmoteAmount && i < paths.length; ++i) {
            ClientEmotePacksManager.DEFAULT_EMOTE_PACK[i] = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)paths[i]);
        }
        cachedEmotePacks = new ConcurrentHashMap<UUID, Map<Integer, byte[]>>();
        cachedLocalEmotePack = null;
        cachedDefaultEmoteBytes = null;
        cachedLocalEmotePackUrls = new ConcurrentHashMap<Integer, String>();
        MAX_PACK_SIZE_BYTES = (Integer)ClientConfig.maxPackSizeMB.get() * 1024 * 1024;
        MAX_PACK_EMOTE_AMOUNT = (Integer)ClientConfig.maxEmoteAmount.get();
        playerEmoteUrls = new ConcurrentHashMap<UUID, Map<Integer, String>>();
        urlDownloader = Executors.newFixedThreadPool(4);
        lastLoadEncounterOversize = false;
        downloadingLocalPlayerUrls = false;
        decoyUUID = UUID.fromString("e4dd6d37-bf11-4855-b155-2e7fea5d152f");
        chunkBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();
        lastDownloadFailLocalUrls = new HashSet<String>();
    }

    private static class ChunkBuffer {
        int totalChunks;
        byte[][] chunks;
        int received = 0;

        ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.received;
                return true;
            }
            return false;
        }

        boolean isComplete() {
            return this.received == this.totalChunks;
        }

        byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

