/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.gui.ClientConfigScreen;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EmotesConfigScreen
extends Screen {
    private final Screen parent;
    private UrlList urlList;
    private Button addButton;
    private Button saveButton;
    private Button doneButton;
    private Button reloadButton;
    private Button configButton;
    private List<String> urls = new ArrayList<String>();
    private final Map<String, ResourceLocation> urlToTexture = new HashMap<String, ResourceLocation>();
    private float reloadTimeout = -1000.0f;

    public EmotesConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Pop-up Emotes"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.urlList = new UrlList(this.f_96541_, this.f_96543_ - 20, this.f_96544_ - 60, 32, this.f_96544_ - 32, 26, this);
        this.urls = new ArrayList<String>((Collection)ClientConfig.emotePackUrls.get());
        this.urls.forEach(url -> this.urlList.addEntry(new UrlListEntry((String)url, this.f_96541_)));
        this.m_142416_((GuiEventListener)this.urlList);
        int btnY = this.f_96544_ - 28;
        this.addButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add URL"), b -> {
            String newUrl = "https://i.ibb.co/pv2yXFhH/example.png";
            this.urls.add(newUrl);
            this.urlList.addEntry(new UrlListEntry(newUrl, this.f_96541_));
        }).m_252794_(10, btnY).m_253046_(80, 20).m_253136_());
        this.reloadButton = Button.m_253074_((Component)Component.m_237113_((String)"Reload & Save"), b -> {
            this.saveUrls();
            ClientEmotePacksManager.recreateCache();
            this.clearEmoteTextures();
            this.loadCustomEmoteTextures();
            b.f_93623_ = false;
            this.reloadTimeout = 20.0f;
        }).m_252794_(100, btnY).m_253046_(100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.reloadButton);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252794_(this.f_96543_ / 2 + 60, btnY).m_253046_(80, 20).m_253136_());
        this.configButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Config"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new ClientConfigScreen());
            }
        }).m_252794_(this.f_96543_ / 2 + 150, btnY).m_253046_(80, 20).m_253136_());
        this.loadCustomEmoteTextures();
    }

    private void saveUrls() {
        ArrayList<String> newUrls = new ArrayList<String>();
        for (UrlListEntry entry : this.urlList.m_6702_()) {
            String url = entry.getUrl();
            if (url.trim().isEmpty()) continue;
            newUrls.add(url.trim());
        }
        ClientConfig.emotePackUrls.set(newUrls);
    }

    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(poseStack);
        this.urlList.m_88315_(poseStack, mouseX, mouseY, partialTick);
        poseStack.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        poseStack.m_280488_(this.f_96547_, "Emote Pack URLs:", 10, 20, 0xFFFFFF);
        if (this.reloadTimeout > -1000.0f) {
            this.reloadTimeout -= partialTick;
            if (this.reloadTimeout <= 0.0f) {
                this.reloadButton.f_93623_ = true;
                this.reloadTimeout = -1000.0f;
            }
        }
        super.m_88315_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7861_() {
        super.m_7861_();
        this.clearEmoteTextures();
    }

    private void clearEmoteTextures() {
        Minecraft mc = Minecraft.m_91087_();
        for (ResourceLocation tex : this.urlToTexture.values()) {
            if (tex == null) continue;
            mc.m_91097_().m_118513_(tex);
        }
        this.urlToTexture.clear();
    }

    private void loadCustomEmoteTextures() {
        if (!((List)ClientConfig.emotePackUrls.get()).isEmpty()) {
            ClientEmotePacksManager.downloadLocalPlayerUrlEmotes();
            new Thread(() -> {
                do {
                    try {
                        Thread.sleep(250L);
                        DebugLogger.debug("Waiting downloadingLocalPlayerUrls");
                        if (Minecraft.m_91087_().f_91080_ instanceof TitleScreen) {
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } while (ClientEmotePacksManager.downloadingLocalPlayerUrls);
                this.loadEmotesAsBytes();
            }).start();
        } else {
            this.loadEmotesAsBytes();
        }
    }

    private void loadEmotesAsBytes() {
        Map<Integer, String> emoteUrls = ClientEmotePacksManager.getLocalPlayerEmoteUrls();
        Map<Integer, byte[]> emotePack = ClientEmotePacksManager.getLocalEmotePack();
        if (emoteUrls == null) {
            emoteUrls = new HashMap<Integer, String>();
        }
        if (emotePack == null) {
            emotePack = new HashMap<Integer, byte[]>();
        }
        Minecraft mc = Minecraft.m_91087_();
        this.clearEmoteTextures();
        for (Integer id : emoteUrls.keySet()) {
            String url = emoteUrls.get(id);
            byte[] bytes = emotePack.get(id);
            if (url == null || bytes == null) continue;
            try {
                NativeImage img = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(bytes));
                DynamicTexture texture = new DynamicTexture(img);
                ResourceLocation location = mc.m_91097_().m_118490_("emote_url_" + url.hashCode(), texture);
                this.urlToTexture.put(url, location);
            }
            catch (Exception e) {
                this.urlToTexture.put(url, null);
                e.printStackTrace();
            }
        }
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        this.m_7379_();
        super.m_6574_(p_96575_, p_96576_, p_96577_);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.urlList.m_7933_(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char code, int modifiers) {
        return this.urlList.m_5534_(code, modifiers) || super.m_5534_(code, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private static class UrlList
    extends ObjectSelectionList<UrlListEntry> {
        private final EmotesConfigScreen parent;

        public UrlList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight, EmotesConfigScreen parent) {
            super(mc, width, height, top, bottom, itemHeight);
            this.parent = parent;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            UrlListEntry selected = (UrlListEntry)this.m_93511_();
            if (selected != null) {
                selected.urlField.m_93692_(false);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.m_6702_().stream().anyMatch(entry -> entry.m_7933_(keyCode, scanCode, modifiers)) || super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char code, int modifiers) {
            return this.m_6702_().stream().anyMatch(entry -> entry.m_5534_(code, modifiers)) || super.m_5534_(code, modifiers);
        }

        public int m_5759_() {
            return this.f_93388_ - 10;
        }

        public boolean removeEntryFromTop(UrlListEntry p_239046_) {
            return super.m_239045_((AbstractSelectionList.Entry)p_239046_);
        }

        public int addEntry(UrlListEntry p_93487_) {
            return super.m_7085_((AbstractSelectionList.Entry)p_93487_);
        }
    }

    private class UrlListEntry
    extends ObjectSelectionList.Entry<UrlListEntry> {
        private final EditBox urlField;
        private final Button pasteButton;
        private final Button deleteButton;
        private final String originalUrl;
        private final Component narration = Component.m_237113_((String)"Url entry");
        public final ResourceLocation invalid = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/invalid.png");
        public final ResourceLocation loading = ResourceLocation.fromNamespaceAndPath((String)"pop_up_emotes", (String)"textures/gui/loading.png");

        public UrlListEntry(String url, Minecraft minecraft) {
            this.originalUrl = url;
            this.urlField = new EditBox(minecraft.f_91062_, 0, 0, 240, 20, (Component)Component.m_237119_());
            this.urlField.m_94199_(256);
            this.urlField.m_94144_(url);
            this.pasteButton = Button.m_253074_((Component)Component.m_237113_((String)"Paste"), b -> this.pasteUrl()).m_252794_(0, 0).m_253046_(40, 20).m_253136_();
            this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
                EmotesConfigScreen.this.urlList.removeEntryFromTop(this);
                EmotesConfigScreen.this.urls.remove(this.originalUrl);
            }).m_252794_(45, 0).m_253046_(20, 20).m_253136_();
        }

        private void pasteUrl() {
            try {
                String clipboardText = Minecraft.m_91087_().f_91068_.m_90876_();
                if (clipboardText != null && !clipboardText.isEmpty()) {
                    this.urlField.m_94144_(clipboardText.trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.deleteButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.pasteButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            this.urlField.m_93692_(true);
            return this.urlField.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.deleteButton.m_6348_(mouseX, mouseY, button);
            this.pasteButton.m_6348_(mouseX, mouseY, button);
            return this.urlField.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_5534_(char code, int modifiers) {
            return this.urlField.m_5534_(code, modifiers);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.urlField.m_7933_(keyCode, scanCode, modifiers);
        }

        public String getUrl() {
            return this.urlField.m_94155_();
        }

        @NotNull
        public Component m_142172_() {
            return this.narration;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.urlField.m_252865_(left + 20);
            this.urlField.m_253211_(top + 2);
            this.urlField.m_93674_(240);
            this.urlField.setHeight(height - 4);
            this.urlField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.pasteButton.m_252865_(left + 265);
            this.pasteButton.m_253211_(top + 2);
            this.pasteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.deleteButton.m_252865_(left + 310);
            this.deleteButton.m_253211_(top + 2);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            String currentUrl = this.urlField.m_94155_();
            ResourceLocation texture = EmotesConfigScreen.this.urlToTexture.get(currentUrl);
            int previewX = left + 375;
            int previewY = top + 2;
            int previewSize = 22;
            if (!ClientEmotePacksManager.downloadingLocalPlayerUrls) {
                if (texture != null) {
                    guiGraphics.m_280163_(texture, previewX, previewY, 0.0f, 0.0f, previewSize, previewSize, previewSize, previewSize);
                } else if (ClientEmotePacksManager.lastDownloadFailLocalUrls.contains(currentUrl)) {
                    guiGraphics.m_280163_(this.invalid, previewX, previewY, 0.0f, 0.0f, previewSize, previewSize, previewSize, previewSize);
                }
            } else {
                guiGraphics.m_280163_(this.loading, previewX, previewY, 0.0f, 0.0f, previewSize, previewSize, previewSize, previewSize);
            }
        }
    }
}

