/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network;

import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.client.ClientEmoteChunkScheduler;
import io.github.catomon.popupemotes.client.ClientEmotePacksManager;
import io.github.catomon.popupemotes.client.EmoteRenderer;
import io.github.catomon.popupemotes.client.ModSounds;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPacket;
import io.github.catomon.popupemotes.network.cts.EmotePackUrlsToServerPacket;
import io.github.catomon.popupemotes.network.cts.RequestEmotePacksToServer;
import io.github.catomon.popupemotes.network.stc.EmotePackModeToClientPacket;
import io.github.catomon.popupemotes.network.stc.EmotePackOverflowToClientPacket;
import io.github.catomon.popupemotes.network.stc.EmotePackUrlsToClientPacket;
import io.github.catomon.popupemotes.network.stc.EmoteToClientPacket;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPacket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static boolean customPacksDisallowed = false;
    public static int emotePackOverflow = -1;

    public static void handle(RequestEmotePackToClientPacket _packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        new Thread(() -> {
            while (ClientEmotePacksManager.downloadingLocalPlayerUrls) {
                try {
                    Thread.sleep(250L);
                    DebugLogger.debug("Waiting downloadingLocalPlayerUrls before sending Emote pack to server");
                    if (!(Minecraft.m_91087_().f_91080_ instanceof TitleScreen)) continue;
                    return;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            context.enqueueWork(ClientPacketHandler::sendEmotePack);
        }).start();
        context.setPacketHandled(true);
    }

    private static void sendEmotePack() {
        if (!((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        List<String> emoteUrls = ClientEmotePacksManager.getLocalEmoteUrls();
        if (ClientEmotePacksManager.serverEmoteMode == 0) {
            if (!emoteUrls.isEmpty()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new EmotePackUrlsToServerPacket(emoteUrls));
            } else {
                ClientPacketHandler.sendLocalFolderEmotePack();
            }
        } else if (ClientEmotePacksManager.serverEmoteMode == 1) {
            if (!emoteUrls.isEmpty()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new EmotePackUrlsToServerPacket(emoteUrls));
            }
        } else if (ClientEmotePacksManager.serverEmoteMode == 2) {
            ClientPacketHandler.sendLocalFolderEmotePack();
        }
    }

    private static void sendLocalFolderEmotePack() {
        assert (ClientEmotePacksManager.serverEmoteMode == 2);
        Map<Integer, byte[]> emotes = ClientEmotePacksManager.getLocalEmotePack();
        if (emotes == null) {
            emotes = new HashMap<Integer, byte[]>();
        }
        int CHUNK_SIZE = 32000;
        for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
            int emoteId = entry.getKey();
            byte[] data = entry.getValue();
            int totalChunks = (data.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(data.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(data, start, end);
                EmotePackChunkToServerPacket packet = new EmotePackChunkToServerPacket(emoteId, chunkIndex, totalChunks, chunk);
                ClientEmoteChunkScheduler.schedule(packet);
            }
        }
    }

    public static void handle(EmoteToClientPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            if (!((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Player player = mc.f_91073_.m_46003_(msg.senderUUID);
            if (player != null) {
                EmoteRenderer.showEmoteOnPlayer(player.m_20148_(), msg.emoteId);
                mc.f_91073_.m_7785_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), (SoundEvent)ModSounds.EMOTE_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handle(EmotePackModeToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (((Boolean)ClientConfig.isEnabled.get()).booleanValue()) {
                if (Minecraft.m_91087_().f_91074_ == null) {
                    return;
                }
                ClientEmotePacksManager.serverEmoteMode = packet.getMode();
                if (packet.isAllowed()) {
                    DebugLogger.debug("Sending RequestEmotePacksToServer");
                    customPacksDisallowed = false;
                    emotePackOverflow = -1;
                    NetworkHandler.INSTANCE.sendToServer((Object)new RequestEmotePacksToServer((Integer)ClientConfig.maxPacketsPerTick.get()));
                    if (packet.getMode() == 2) {
                        customPacksDisallowed = true;
                    }
                    return;
                }
                Map<Integer, byte[]> localEmotePack = ClientEmotePacksManager.getLocalEmotePack();
                if (localEmotePack == null) {
                    return;
                }
                if (localEmotePack.isEmpty()) {
                    return;
                }
                customPacksDisallowed = true;
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Pop-up Emotes] Custom packs are disallowed on this server!."));
            }
        });
        context.setPacketHandled(true);
    }

    public static void handle(EmotePackOverflowToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            emotePackOverflow = packet.emoteId;
        });
        context.setPacketHandled(true);
    }

    public static void handle(EmotePackUrlsToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(false);
            return;
        }
        context.enqueueWork(() -> {
            UUID senderUUID = packet.senderUUID;
            List<String> urls = packet.urls;
            DebugLogger.debug("Received " + urls.size() + " emote URLs from " + senderUUID);
            ClientEmotePacksManager.cachePlayerEmoteUrls(senderUUID, urls);
        });
        context.setPacketHandled(true);
    }
}

