/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackOverflowToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmoteChunkScheduler;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class EmotePackChunkToServerPacket {
    private static final int CHUNK_SIZE = 32000;
    private final int emoteId;
    private final int chunkIndex;
    private final int totalChunks;
    private final byte[] chunkData;
    public static final Map<UUID, Map<Integer, ChunkBuffer>> playerBuffers = new ConcurrentHashMap<UUID, Map<Integer, ChunkBuffer>>();
    private static String playerWarnedId;

    public EmotePackChunkToServerPacket(int emoteId, int chunkIndex, int totalChunks, byte[] chunkData) {
        this.emoteId = emoteId;
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.chunkData = chunkData;
    }

    public EmotePackChunkToServerPacket(FriendlyByteBuf buf) {
        this.emoteId = buf.readInt();
        this.chunkIndex = buf.readInt();
        this.totalChunks = buf.readInt();
        this.chunkData = buf.m_130052_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.emoteId);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130087_(this.chunkData);
    }

    public static void handle(EmotePackChunkToServerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (!((Boolean)ServerConfig.allowCustomPacks.get()).booleanValue()) {
                return;
            }
            ServerPlayer player = context.getSender();
            UUID sender = player.m_20148_();
            int emoteId = packet.emoteId;
            playerBuffers.putIfAbsent(sender, new ConcurrentHashMap());
            Map<Integer, ChunkBuffer> emoteMap = playerBuffers.get(sender);
            emoteMap.putIfAbsent(emoteId, new ChunkBuffer(packet.totalChunks));
            ChunkBuffer buffer = emoteMap.get(emoteId);
            boolean added = buffer.addChunk(packet.chunkIndex, packet.chunkData);
            if (!added) {
                DebugLogger.debug("[EmotePackChunkToServerPacket.handle] !added == true Duplicate or out of bound chunk");
                return;
            }
            if (buffer.isComplete()) {
                byte[] fullEmoteData;
                block7: {
                    fullEmoteData = buffer.assemble();
                    DebugLogger.debug("Emote data " + emoteId + " from player " + sender + " received.");
                    try {
                        ServerEmotePacksManager.setPlayerEmote(sender, emoteId, fullEmoteData);
                    }
                    catch (ServerEmotePacksManager.OverflowException exception) {
                        DebugLogger.error("Cannot set emote " + emoteId + " from player " + sender + " as the pack will exceed the size limit.");
                        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EmotePackOverflowToClientPacket(emoteId));
                        if (player == null || Objects.equals(playerWarnedId, player.m_20149_())) break block7;
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + Component.m_237115_((String)"pop_up_emotes.sysmsg.player_pack_too_large").getString() + ServerEmotePacksManager.MAX_PACK_SIZE_BYTES / 1024 / 1024 + "Mb. " + Component.m_237115_((String)"pop_up_emotes.sysmsg.server_emote_amount_limit").getString() + ServerEmotePacksManager.MAX_PACK_EMOTE_AMOUNT + ".")));
                        playerWarnedId = player.m_20149_();
                    }
                }
                if (player != null) {
                    EmotePackChunkToServerPacket.scheduleSendEmoteToPlayers(player, Map.of(emoteId, fullEmoteData));
                }
                emoteMap.remove(emoteId);
                if (emoteMap.isEmpty()) {
                    playerBuffers.remove(sender);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static void scheduleSendEmoteToPlayers(ServerPlayer emotesOwnerPlayer, Map<Integer, byte[]> emotes) {
        UUID ownerUUID = emotesOwnerPlayer.m_20148_();
        List players = emotesOwnerPlayer.f_8924_.m_6846_().m_11314_();
        for (ServerPlayer targetPlayer : players) {
            if (targetPlayer.m_20148_().equals(ownerUUID)) continue;
            ServerEmoteChunkScheduler.enqueueEmoteChunkPacket(targetPlayer, ownerUUID, emotes);
        }
    }

    public static class ChunkBuffer {
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        public ChunkBuffer(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        public boolean addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
                return true;
            }
            return false;
        }

        public boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        public byte[] assemble() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.totalChunks; ++i) {
                    baos.write(this.chunks[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return baos.toByteArray();
        }
    }
}

