/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.ClientConfig;
import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackOverflowToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class EmotePackUrlsToServerPacket {
    private static final int MAX_URLS_PER_PACKET = 500;
    private static final int MAX_URL_LENGTH = 256;
    private final List<String> urls;

    public EmotePackUrlsToServerPacket(List<String> urls) {
        if (urls.size() > 500) {
            throw new IllegalArgumentException("MAX_URLS_PER_PACKET ulrs > 500");
        }
        if (urls.size() > (Integer)ClientConfig.maxEmoteAmount.get()) {
            throw new IllegalArgumentException("maxEmoteAmount ulrs > " + ClientConfig.maxEmoteAmount.get());
        }
        this.urls = List.copyOf(urls);
    }

    public EmotePackUrlsToServerPacket(FriendlyByteBuf buf) {
        this.urls = buf.m_236845_(b -> {
            String url = b.m_130136_(256);
            if (url.isEmpty()) {
                DebugLogger.warn("[Pop-up Emotes] Client sent empty URL.");
                return "invalid";
            }
            return url;
        });
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236828_(this.urls, (b, url) -> {
            if (url.length() > 256) {
                DebugLogger.warn("URL too long: " + url);
                b.m_130072_("invalid", 256);
            } else {
                b.m_130072_(url, 256);
            }
        });
    }

    public static void handle(EmotePackUrlsToServerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (!((Boolean)ServerConfig.allowCustomPacks.get()).booleanValue()) {
                return;
            }
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            UUID sender = context.getSender().m_20148_();
            if (!sender.equals(player.m_20148_())) {
                DebugLogger.warn("UUID mismatch in EmotePackUrlsToServerPacket");
                return;
            }
            List<String> urls = packet.urls;
            DebugLogger.debug("Received " + urls.size() + " emote URLs from " + sender);
            ServerEmotePacksManager.setPlayerEmoteUrls(sender, urls);
            ServerEmotePacksManager.broadcastUrlsToPlayers(player, urls);
            if (urls.size() > ServerEmotePacksManager.MAX_PACK_EMOTE_AMOUNT) {
                DebugLogger.error("Emote URLs from " + sender + " exceed limits");
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EmotePackOverflowToClientPacket(ServerEmotePacksManager.MAX_PACK_EMOTE_AMOUNT));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7cEmote pack URLs exceed server limits (" + ServerEmotePacksManager.MAX_PACK_EMOTE_AMOUNT + " max).")));
            }
        });
        context.setPacketHandled(true);
    }
}

