/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.cts;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackUrlsToClientPacket;
import io.github.catomon.popupemotes.network.stc.RequestEmotePackToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmoteChunkScheduler;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RequestEmotePacksToServer {
    private final int maxPacketsPerTick;

    public RequestEmotePacksToServer(int maxPacketsPerTick) {
        this.maxPacketsPerTick = maxPacketsPerTick;
    }

    public RequestEmotePacksToServer(FriendlyByteBuf buf) {
        int bw = buf.readInt();
        this.maxPacketsPerTick = Math.min(16000, Math.max(128, bw));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.maxPacketsPerTick);
    }

    public static void handle(RequestEmotePacksToServer packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = ctx.get().getSender();
        context.enqueueWork(() -> {
            if (player == null) {
                return;
            }
            int emoteMode = ServerConfig.getEmoteMode();
            if (emoteMode >= 0) {
                if (emoteMode == 2) {
                    RequestEmotePacksToServer.sendImageEmotePack(packet, player);
                } else {
                    Map<UUID, List<String>> playerEmoteUrls = ServerEmotePacksManager.getPlayerEmoteUrls();
                    for (UUID ownerUUID : playerEmoteUrls.keySet()) {
                        if (ownerUUID == player.m_20148_()) continue;
                        List<String> urls = playerEmoteUrls.get(ownerUUID);
                        if (urls == null) {
                            if (emoteMode != 0) continue;
                            throw new IllegalStateException("MODE_BOTH now supported rn");
                        }
                        DebugLogger.debug("Sending Url Emote Packs To Player");
                        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EmotePackUrlsToClientPacket(ownerUUID, urls));
                    }
                }
                DebugLogger.debug("Sending RequestEmotePackToClientPacket");
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestEmotePackToClientPacket());
            }
        });
        context.setPacketHandled(true);
    }

    private static void sendImageEmotePack(RequestEmotePacksToServer packet, ServerPlayer player) {
        Map<UUID, Map<Integer, byte[]>> allEmotePacks = ServerEmotePacksManager.getAllPlayerEmotePacks();
        DebugLogger.debug("Sending Image Emote Packs To Player");
        ServerEmoteChunkScheduler.sendEmotePacksToPlayer(player, allEmotePacks, packet.maxPacketsPerTick);
    }
}

