/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.stc;

import io.github.catomon.popupemotes.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class EmotePackModeToClientPacket {
    public static final int MODE_DISABLED = -1;
    public static final int MODE_BOTH = 0;
    public static final int MODE_URLS_ONLY = 1;
    public static final int MODE_IMAGES_ONLY = 2;
    private final int mode;

    public EmotePackModeToClientPacket(int mode) {
        if (mode < -1 || mode > 2) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.mode = mode;
    }

    public EmotePackModeToClientPacket(FriendlyByteBuf buf) {
        this.mode = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.mode);
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isAllowed() {
        return this.mode >= 0;
    }

    public boolean allowsUrls() {
        return this.mode == 0 || this.mode == 1;
    }

    public boolean allowsImages() {
        return this.mode == 0 || this.mode == 2;
    }

    public static void handle(EmotePackModeToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientPacketHandler.handle(packet, ctx);
    }
}

