/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.network.stc;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.network.ClientPacketHandler;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class EmotePackUrlsToClientPacket {
    private static final int MAX_URL_LENGTH = 256;
    private static final int MAX_URLS_PER_PACKET = 500;
    public final UUID senderUUID;
    public final List<String> urls;

    public EmotePackUrlsToClientPacket(UUID senderUUID, List<String> urls) {
        this.senderUUID = senderUUID;
        this.urls = List.copyOf(urls);
    }

    public EmotePackUrlsToClientPacket(FriendlyByteBuf buf) {
        this.senderUUID = buf.m_130259_();
        this.urls = buf.m_236845_(b -> {
            int len = b.m_130242_();
            if (len == 0 || len > 256) {
                DebugLogger.warn("Invalid URL length " + len + " from " + this.senderUUID);
                b.skipBytes(len);
                return "invalid://len=" + len;
            }
            return b.m_130136_(len);
        });
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.senderUUID);
        buf.m_236828_(this.urls, (b, url) -> {
            int len = url.length();
            if (len == 0 || len > 256) {
                throw new IllegalArgumentException("Invalid URL length: " + len);
            }
            b.m_130130_(len);
            b.m_130072_(url, len);
        });
    }

    public static void handle(EmotePackUrlsToClientPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientPacketHandler.handle(packet, ctx);
    }
}

