/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.cts.EmotePackChunkToServerPacket;
import io.github.catomon.popupemotes.network.stc.EmotePackModeToClientPacket;
import io.github.catomon.popupemotes.server.ServerEmoteChunkScheduler;
import io.github.catomon.popupemotes.server.ServerEmotePacksManager;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class PlayerJoinHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (((Boolean)ServerConfig.allowCustomPacks.get()).booleanValue()) {
            DebugLogger.debug("Sending EmotePackModeToClientPacket");
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new EmotePackModeToClientPacket(ServerConfig.getEmoteMode()));
        }
    }

    @SubscribeEvent
    public static void onPlayerExit(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        ServerEmotePacksManager.removePlayerEmotePack(playerUUID);
        EmotePackChunkToServerPacket.playerBuffers.remove(playerUUID);
        ServerEmoteChunkScheduler.removePlayer(player2);
    }
}

