/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import io.github.catomon.popupemotes.DebugLogger;
import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackChunkToClientPacket;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ServerEmoteChunkScheduler {
    public static int maxPacketsPerTickPerPlayer = 8;
    public static int maxPacketsPerTick = 10;
    private static final Map<ServerPlayer, PlayerPacketQueue> playerQueues = new ConcurrentHashMap<ServerPlayer, PlayerPacketQueue>();
    private static final int CHUNK_SIZE = 32000;

    public static void sendEmotePacksToPlayer(ServerPlayer recipient, Map<UUID, Map<Integer, byte[]>> emotePacks, int maxPacketsPerTick) {
        for (Map.Entry<UUID, Map<Integer, byte[]>> entry : emotePacks.entrySet()) {
            UUID ownerUUID = entry.getKey();
            Map<Integer, byte[]> emotes = entry.getValue();
            ServerEmoteChunkScheduler.enqueueEmoteChunkPacket(recipient, ownerUUID, emotes, maxPacketsPerTick);
        }
    }

    public static void enqueueEmoteChunkPacket(ServerPlayer recipient, UUID emoteOwnerUUID, Map<Integer, byte[]> emotes, int maxPacketsPerTick) {
        assert (ServerConfig.getEmoteMode() == 2);
        playerQueues.putIfAbsent(recipient, new PlayerPacketQueue(maxPacketsPerTick));
        PlayerPacketQueue playerQueue = playerQueues.get(recipient);
        for (Map.Entry<Integer, byte[]> entry : emotes.entrySet()) {
            int emoteId = entry.getKey();
            byte[] fullData = entry.getValue();
            int totalChunks = (fullData.length + 32000 - 1) / 32000;
            for (int chunkIndex = 0; chunkIndex < totalChunks; ++chunkIndex) {
                int start = chunkIndex * 32000;
                int end = Math.min(fullData.length, start + 32000);
                byte[] chunk = Arrays.copyOfRange(fullData, start, end);
                EmotePackChunkToClientPacket packet = new EmotePackChunkToClientPacket(emoteOwnerUUID, emoteId, chunkIndex, totalChunks, chunk);
                playerQueue.queue.add(packet);
            }
        }
    }

    public static void enqueueEmoteChunkPacket(ServerPlayer recipient, UUID emoteOwnerUUID, Map<Integer, byte[]> emotes) {
        ServerEmoteChunkScheduler.enqueueEmoteChunkPacket(recipient, emoteOwnerUUID, emotes, maxPacketsPerTickPerPlayer);
    }

    public static void removePlayer(ServerPlayer player) {
        playerQueues.remove(player);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            int packetsSent = 0;
            for (Map.Entry<ServerPlayer, PlayerPacketQueue> entry : playerQueues.entrySet()) {
                ServerPlayer player = entry.getKey();
                PlayerPacketQueue value = entry.getValue();
                int packetPerTick = value.packetsPerTick;
                ArrayDeque<EmotePackChunkToClientPacket> packetQueue = value.queue;
                if (packetQueue.isEmpty()) continue;
                for (int i = 0; i < packetPerTick && !packetQueue.isEmpty(); ++i) {
                    EmotePackChunkToClientPacket packet = packetQueue.peek();
                    DebugLogger.debug("Sending EmotePackChunkToClientPacket");
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                    packetQueue.poll();
                    if (++packetsSent < maxPacketsPerTick) continue;
                    return;
                }
            }
        }
    }

    public static class PlayerPacketQueue {
        public final ArrayDeque<EmotePackChunkToClientPacket> queue = new ArrayDeque();
        public int packetsPerTick;

        public PlayerPacketQueue(int packetsPerTick) {
            this.packetsPerTick = Math.max(Math.min(packetsPerTick, maxPacketsPerTickPerPlayer), 1);
        }
    }
}

