/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.popupemotes.server;

import io.github.catomon.popupemotes.ServerConfig;
import io.github.catomon.popupemotes.network.NetworkHandler;
import io.github.catomon.popupemotes.network.stc.EmotePackUrlsToClientPacket;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class ServerEmotePacksManager {
    private static final Map<UUID, Map<Integer, byte[]>> playerEmotePacks = new ConcurrentHashMap<UUID, Map<Integer, byte[]>>();
    private static final Map<UUID, List<String>> playerEmoteUrls = new ConcurrentHashMap<UUID, List<String>>();
    public static final int MAX_PACK_SIZE_BYTES = (Integer)ServerConfig.maxPackSizeMB.get() * 1024 * 1024;
    public static final int MAX_PACK_EMOTE_AMOUNT = (Integer)ServerConfig.maxEmoteAmount.get();

    private static int getTotalPackSize(Map<Integer, byte[]> pack) {
        return pack.values().stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
    }

    private static int getRemainingSpace(Map<Integer, byte[]> pack) {
        return MAX_PACK_SIZE_BYTES - ServerEmotePacksManager.getTotalPackSize(pack);
    }

    public static boolean canPut(UUID playerUUID, byte[] emoteData) {
        Map<Integer, byte[]> emoteMap = playerEmotePacks.get(playerUUID);
        if (emoteMap == null) {
            return emoteData.length <= MAX_PACK_SIZE_BYTES;
        }
        return ServerEmotePacksManager.getTotalPackSize(emoteMap) + emoteData.length <= MAX_PACK_SIZE_BYTES;
    }

    public static int getRemainingSpace(UUID playerUUID) {
        Map<Integer, byte[]> emoteMap = playerEmotePacks.get(playerUUID);
        if (emoteMap == null) {
            return MAX_PACK_SIZE_BYTES;
        }
        return ServerEmotePacksManager.getRemainingSpace(emoteMap);
    }

    public static void setPlayerEmotePack(UUID playerUUID, Map<Integer, byte[]> emotes) throws OverflowException {
        int totalSize = ServerEmotePacksManager.getTotalPackSize(emotes);
        if (totalSize > MAX_PACK_SIZE_BYTES) {
            throw new OverflowException("Emote pack exceeds maximum allowed pack size.");
        }
        playerEmotePacks.put(playerUUID, emotes);
    }

    public static void setPlayerEmote(UUID playerUUID, int emoteId, byte[] emoteData) throws OverflowException {
        playerEmotePacks.compute(playerUUID, (uuid, emoteMap) -> {
            if (emoteMap == null) {
                emoteMap = new ConcurrentHashMap<Integer, byte[]>();
            }
            if (emoteMap.size() == MAX_PACK_EMOTE_AMOUNT) {
                throw new OverflowException("Adding this emote exceeds the pack emote amount limit.");
            }
            int currentSize = ServerEmotePacksManager.getTotalPackSize(emoteMap);
            int newSize = currentSize - emoteMap.getOrDefault(emoteId, new byte[0]).length + emoteData.length;
            if (newSize > MAX_PACK_SIZE_BYTES) {
                throw new OverflowException("Adding this emote exceeds the pack size limit.");
            }
            emoteMap.put(emoteId, emoteData);
            return emoteMap;
        });
    }

    public static Map<Integer, byte[]> getPlayerEmotePack(UUID playerUUID) {
        return playerEmotePacks.getOrDefault(playerUUID, Map.of());
    }

    public static void removePlayerEmotePack(UUID playerUUID) {
        playerEmotePacks.remove(playerUUID);
        playerEmoteUrls.remove(playerUUID);
    }

    public static Map<UUID, Map<Integer, byte[]>> getAllPlayerEmotePacks() {
        return playerEmotePacks;
    }

    public static void setPlayerEmoteUrls(UUID sender, List<String> urls) {
        playerEmoteUrls.put(sender, urls);
    }

    public static void broadcastUrlsToPlayers(ServerPlayer owner, List<String> urls) {
        List players = owner.f_8924_.m_6846_().m_11314_();
        for (ServerPlayer target : players) {
            if (target.m_20148_().equals(owner.m_20148_())) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)new EmotePackUrlsToClientPacket(owner.m_20148_(), urls));
        }
    }

    public static Map<UUID, List<String>> getPlayerEmoteUrls() {
        return playerEmoteUrls;
    }

    public static class OverflowException
    extends RuntimeException {
        public OverflowException(String message) {
            super(message);
        }
    }
}

