StartupEvents.registry('palladium:abilities', (event) => {
    event.create('spring_core:change_health_last_tick')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

        .documentationDescription('On the last tick of the power change your hp to the wanted value')
        .addProperty("hp", "integer", 0, "The amount of hp you will have")

        .lastTick((entity, entry, holder, enabled) => {
            if (entity.isPlayer()) {
                const hp = entry.getPropertyByName("hp");
                entity.health = hp;
            }
        });
});