StartupEvents.registry('palladium:abilities', event => {
    event.create('spring_core:damaging_raycast')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('You can bite your enemies')

        .addProperty('distance', 'integer', 0, 'the distance it reach')
        .addProperty('damage', 'integer', 0, 'the damage you deal to the target')
        .addProperty('fire_duration', 'integer', 0, 'the duration of the fire effect if you want one')
        .addProperty('potion', 'string', 'minecraft:wither', 'the potion effect you apply to the target')
        .addProperty('potion_duration', 'integer', 60, 'the duration of the potion effect')
        .addProperty('potion_amplifier', 'integer', 0, 'the amplifier of the potion effect')

        .firstTick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            const distance = entry.getPropertyByName("distance")
            const damage = entry.getPropertyByName("damage")
            const fire_duration = entry.getPropertyByName("fire_duration")
            const potion = entry.getPropertyByName("potion")
            const potion_duration = entry.getPropertyByName("potion_duration")
            const potion_amplifier = entry.getPropertyByName("potion_amplifier")

            let target = entity.rayTrace(distance).entity;

            if (target) {
                target.attack(damage)
                if (fire_duration > 0) {
                    target.setSecondsOnFire(fire_duration)
                }

                if (potion_duration > 0) {
                    target.potionEffects.add(potion, potion_duration, potion_amplifier, false, true)
                }
                
                
            }
        });
});
