(function () {
    StartupEvents.registry('palladium:condition_serializer', (event) => {
        let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil')
        let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper')
        event.create('spring_core:rf_condition')

            .addProperty("rf_nb", "integer", 1, "The amount of rf that you search")
            .addProperty("comparison", "string", ">", "compare your rf with the value your search : <, <=, >, >=")
            .addProperty("item_to_drain", "string", "spring:comic_mk1_batterie", "id of the item")
            .addProperty("curios_slot", "string", "body", "name of the slot")

            .test((entity, properties) => {
                const rf_nb = properties.get("rf_nb");
                const calculation_type = properties.get("comparison");
                const curios_slot = properties.get("curios_slot");
                const id = properties.get("item_to_drain");

                let items = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot);

                for (let i = 0; i < items.length; i++) {
                    let item = items[i];
                    if (item.id === id) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            let energyStored = energyHolder.getEnergyAmount()
                            if (calculation_type == ">") {
                                return energyStored > rf_nb;
                            } else if (calculation_type == ">=") {
                                return energyStored >= rf_nb;
                            } else if (calculation_type == "<") {
                                return energyStored < rf_nb;
                            } else if (calculation_type == "<=") {
                                return energyStored <= rf_nb;
                            } else {
                                console.error(`Error`);
                            }
                        };
                    };
                };
                return false;
            });
    });
})();