(function () {
    StartupEvents.registry('palladium:abilities', (event) => {

        let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil')
        let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper')

        event.create('spring_core:drain_per_tick')

            .icon(palladium.createItemIcon('minecraft:golden_apple'))
            .documentationDescription('Abilitie using kube js to drain your rf energy')

            .addProperty("rf_nb", "integer", 1, "The amount of rf")
            .addProperty("calculation_type", "string", "add", "operation type can only be substract or add")
            .addProperty("curios_slot", "string", "body", "name of the slot")

            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                const rf_nb = entry.getPropertyByName("rf_nb");
                const calculation_type = entry.getPropertyByName("calculation_type");
                const curios_slot = entry.getPropertyByName("curios_slot");

                let item = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot);

                function EnergyItem(item) {
                    let holderWrapper = EnergyHelper.getFromItemStack(item);
                    if (holderWrapper.isPresent()) {
                        let energyHolder = holderWrapper.get();
                        if (calculation_type == "add") {
                            energyHolder.insertEnergy(rf_nb, false);
                            console.error(`insert`);
                        } else if (calculation_type == "substract") {
                            energyHolder.withdrawEnergy(rf_nb, false);
                            console.error(`remove`);
                        } else {
                            console.error(`Error`);
                        }
                    }
                }
                item.forEach(EnergyItem);
            });
    });
})();    