const ExpPower = [
    'spring:giant',
    'spring:zombie'
]


PalladiumEvents.registerGuiOverlays((event) => {
    event.register(
        'springcore:exp_hud',

        (minecraft, gui, poseStack, partialTick, screenWidth, screenHeight) => {
            let player = minecraft.player;
            let playerName = player.getGameProfile().getName();
            if (!player) return;

            let power = palladium.powers.getPowerIds(player);


            if (power) {
                let rawPowerId = power[0].toString();
                let firstpower = rawPowerId.split(":").pop();

                if (ExpPower.includes(rawPowerId)) {
                    let scoreboard = Utils.server.scoreboard;
                    let scoreboardNameXP = firstpower + "XP";
                    let scoreboardNameLevel = firstpower + "Level";
                    let scoreboardNamePoint = firstpower + "Point";

                    let xpobjective = scoreboard.getObjective(scoreboardNameXP);
                    let levelobjective = scoreboard.getObjective(scoreboardNameLevel);
                    let pointobjective = scoreboard.getObjective(scoreboardNamePoint);

                    let xpscoreboard = scoreboard.getOrCreatePlayerScore(playerName, xpobjective);
                    let XpPoint = xpscoreboard.getScore();

                    let levelscoreboard = scoreboard.getOrCreatePlayerScore(playerName, levelobjective);
                    let LevelPoint = levelscoreboard.getScore();

                    let pointscore = scoreboard.getOrCreatePlayerScore(playerName, pointobjective);
                    let SkillPoint = pointscore.getScore();

                    let XPNeeded = 100 + (100 * (LevelPoint * 0.5));

                    guiUtil.drawString(poseStack, Component.string(`XP: ${XpPoint} / ${XPNeeded}`), 410, 5, 0xffffff);
                    guiUtil.drawString(poseStack, Component.string(`Level: ${LevelPoint}`), 340, 5, 0xffffff);
                    guiUtil.drawString(poseStack, Component.string(`SkillPoint: ${SkillPoint}`), 410, 20, 0xffffff);

                    //console.error(XpPoint)
                    //console.error(LevelPoint)
                    //console.error(SkillPoint)
                }
            }
        });
});