StartupEvents.registry('palladium:condition_serializer', (event) => {
	event.create('spring_core:armor_durability_dual')

		.addProperty('armor_piece', 'integer', 1, "0 = boots, 1 = leggings, 2 = chestplate, 3 = helmet")
		.addProperty('divider', 'float', 1.0, 'this part is made to decide what value you are searching with division')
		.addProperty('divider2', 'float', 1.0, 'this part is made to decide what value you are searching with division')


		.test((entity, properties) => {
			const armor_piece = properties.get("armor_piece");
			const divider = properties.get("divider");
			const divider2 = properties.get("divider2");
			let slot;

			if (entity.getInventory) {
				slot = entity.getInventory().getArmor(armor_piece);
			} else if (entity.allSlots.forEach) {
				
				return false
			}

			if (slot != null) {
				if (!slot.isEmpty() && divider > 0) {
					const maxDurability = slot.maxDamage;
					const currentDamage = slot.damageValue;

					const durabilityLeft = maxDurability - currentDamage;
					const maxRequiredDurability = maxDurability / divider;
					const minRequiredDurability = maxDurability / divider2;

					return ((durabilityLeft >= minRequiredDurability) && (durabilityLeft <= maxRequiredDurability));
				}
			}

			return false;
		});
});
