EntityEvents.death(event => {
    let source = event.source;
    let dead = event.entity;
    let xpgain = Math.max(1, Math.round(dead.maxHealth * (0.5 + Math.random() * 0.7)));

    console.error(`XP Given: ${xpgain}`);

    if (source.player) {
        let player = source.player;
        let playerName = player.getGameProfile().getName();

        let power = palladium.powers.getPowerIds(player);

        if (power) {
            let rawPowerId = power[0].toString();
            let firstpower = rawPowerId.split(":").pop();

            console.error(firstpower);

            let scoreboardNameXP = firstpower+"XP";
            let scoreboardNameLevel = firstpower+"Level";
            let scoreboardNamePoint = firstpower+"Point";

            let scoreboard = Utils.server.scoreboard;
            
            let xpobjective = scoreboard.getObjective(scoreboardNameXP);
            let levelobjective = scoreboard.getObjective(scoreboardNameLevel);
            let pointobjective = scoreboard.getObjective(scoreboardNamePoint);

            if (xpobjective && levelobjective && pointobjective) {
                let xpscoreboard = scoreboard.getOrCreatePlayerScore(playerName,xpobjective);
                let xpvalue = xpscoreboard.getScore();

                let levelscoreboard = scoreboard.getOrCreatePlayerScore(playerName,levelobjective);
                let levelvalue = levelscoreboard.getScore();

                let pointscore = scoreboard.getOrCreatePlayerScore(playerName,pointobjective);
                let pointvalue = pointscore.getScore();

                xpscoreboard.setScore(xpvalue + xpgain);

                let XPNeeded = 100 + (100 * (levelvalue * 0.5));
                
                if (xpvalue >= XPNeeded ) {
                    xpscoreboard.setScore(xpvalue - XPNeeded);
                    pointscore.setScore(pointvalue + 1);
                    levelscoreboard.setScore(levelvalue + 1);
                    
                }
            }

        }
    }
});