(function () {
    StartupEvents.registry('palladium:abilities', (event) => {

        let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil')
        let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper')

        event.create('spring_core:rf_scoeboard')

            .icon(palladium.createItemIcon('minecraft:golden_apple'))
            .documentationDescription('Abilitie using kube js to drain your rf energy')

            .addProperty("curios_slot", "string", "body", "name of the slot")
            .addProperty('score_rf', 'string', 'null', 'score for actual rf')
            .addProperty('score_max', 'string', 'null', 'score for max rf')

            .tick((entity, entry, holder, enabled) => {
                if (!enabled || !entity.isPlayer() ) return;

                const curios_slot = entry.getPropertyByName("curios_slot");
                const act_rf = entry.getPropertyByName("score_rf")
                const max_rf = entry.getPropertyByName("score_max")

                let scoreboard = Utils.server.scoreboard;
                let Plr = entity.getGameProfile().getName()

                let act_rf_objective = scoreboard.getObjective(act_rf);
                let max_rf_objectif = scoreboard.getObjective(max_rf);

                let act_rf_scoreboard = scoreboard.getOrCreatePlayerScore(Plr, act_rf_objective);
                let max_rfscoreboard = scoreboard.getOrCreatePlayerScore(Plr, max_rf_objectif);


                let item = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot);

                function EnergyItem(item) {
                    if (item && !item.isEmpty()) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            let current_energy = energyHolder.getEnergyAmount();
                            let max_energy = energyHolder.getEnergyCapacity();

                            act_rf_scoreboard.setScore(current_energy);
                            max_rfscoreboard.setScore(max_energy);
                        }
                    }

                }

                if (item && !item.isEmpty()) {
                    item.forEach(EnergyItem);
                }else {
                    act_rf_scoreboard.setScore(0);
                    max_rfscoreboard.setScore(0);
                }
                



            });
    });
})();    