/*
 * Decompiled with CFR 0.152.
 */
package com.victorgponce.entityrenderdisablerrewritefabric.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.victorgponce.entityrenderdisablerrewritefabric.client.EntityrenderdisablerrewritefabricClient;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("entityrenderdisabler.json").toFile();
    private static boolean modEnabled = true;
    private static Map<String, Boolean> entityRenderStates = new HashMap<String, Boolean>();

    public static boolean isEntityVisible(String entityId) {
        return entityRenderStates.getOrDefault(entityId, true);
    }

    public static void setEntityVisible(String entityId, boolean visible) {
        entityRenderStates.put(entityId, visible);
        ModConfig.save();
    }

    public static boolean isModEnabled() {
        return modEnabled;
    }

    public static void setModEnabled(boolean enabled) {
        modEnabled = enabled;
        ModConfig.save();
    }

    public static void load() {
        try {
            if (CONFIG_FILE.exists()) {
                JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(CONFIG_FILE), JsonObject.class);
                if (json.has("modEnabled")) {
                    modEnabled = json.get("modEnabled").getAsBoolean();
                }
                Type type = new TypeToken<Map<String, Boolean>>(){}.getType();
                entityRenderStates = json.has("entities") ? (Map<Object, Object>)GSON.fromJson(json.get("entities"), type) : new HashMap<String, Boolean>();
            } else {
                entityRenderStates = new HashMap<String, Boolean>();
                ModConfig.save();
            }
        }
        catch (IOException e) {
            EntityrenderdisablerrewritefabricClient.LOGGER.error("Failed to load config", (Throwable)e);
            entityRenderStates = new HashMap<String, Boolean>();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                JsonObject json = new JsonObject();
                json.addProperty("modEnabled", Boolean.valueOf(modEnabled));
                json.add("entities", GSON.toJsonTree(entityRenderStates));
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            EntityrenderdisablerrewritefabricClient.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static Map<String, Boolean> getEntityRenderStates() {
        return entityRenderStates;
    }
}

