/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.NotNull;

public class CryingSlabBlock
extends SlabBlock {
    public CryingSlabBlock(BlockBehaviour.Properties p_56359_) {
        super(p_56359_);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, RandomSource random) {
        Direction direction;
        if (random.nextInt(5) == 0 && (direction = Direction.getRandom((RandomSource)random)) != Direction.UP) {
            BlockPos blockpos = pos.relative(direction);
            BlockState blockstate = world.getBlockState(blockpos);
            if (!state.canOcclude() || !blockstate.isFaceSturdy((BlockGetter)world, blockpos, direction.getOpposite())) {
                double yOffset = state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM ? 0.25 : 0.75;
                double xOffset = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.5;
                double zOffset = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.5;
                world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_OBSIDIAN_TEAR, (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }
}

