/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core;

import com.davigj.frame_changer.core.FCConfig;
import com.davigj.frame_changer.core.data.client.FCBlockStateProvider;
import com.davigj.frame_changer.core.data.server.FCBlockTagsProvider;
import com.davigj.frame_changer.core.data.server.FCRecipeProvider;
import com.davigj.frame_changer.core.other.FCClientCompat;
import com.davigj.frame_changer.core.other.FCConstants;
import com.davigj.frame_changer.core.other.FCDataMapUtil;
import com.davigj.frame_changer.core.registry.FCBlocks;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@Mod(value="frame_changer")
public class FrameChanger {
    public static final String MOD_ID = "frame_changer";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("frame_changer");

    public FrameChanger(IEventBus bus, ModContainer container) {
        FCBlocks.BLOCKS.register(bus);
        FCBlocks.ITEMS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerDataMapTypes);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FCConfig.COMMON_SPEC);
        if (FMLEnvironment.dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    @SubscribeEvent
    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> FCConstants.determineChiselMap());
    }

    @SubscribeEvent
    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(FCClientCompat::register);
    }

    @SubscribeEvent
    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        FCBlockTagsProvider blockTags = new FCBlockTagsProvider(output, provider, helper);
        generator.addProvider(includeServer, (DataProvider)blockTags);
        generator.addProvider(includeServer, (DataProvider)new FCRecipeProvider(output, provider));
        boolean includeClient = event.includeClient();
        generator.addProvider(includeClient, (DataProvider)new FCBlockStateProvider(output, helper));
    }

    @SubscribeEvent
    private void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        event.register(FCDataMapUtil.CRYING_CONVERTS);
        event.register(FCDataMapUtil.SPELUNKERY_PORTAL_FLUID_DRAIN_CONVERTS);
    }
}

