/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core.data.client;

import com.davigj.frame_changer.core.registry.FCBlocks;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class FCBlockStateProvider
extends BlockStateProvider {
    public FCBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "frame_changer", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.pillarBlock(FCBlocks.OBSIDIAN_PILLAR.get());
        this.pillarBlock(FCBlocks.CRYING_OBSIDIAN_PILLAR.get());
        this.block(FCBlocks.CHISELED_OBSIDIAN.get());
        this.block(FCBlocks.CRYING_CHISELED_OBSIDIAN.get());
        this.groupSSW(FCBlocks.OBSIDIAN_BRICKS.get(), FCBlocks.OBSIDIAN_BRICK_STAIRS.get(), FCBlocks.OBSIDIAN_BRICK_SLAB.get(), FCBlocks.OBSIDIAN_BRICK_WALL.get());
        this.groupSSW(FCBlocks.CRYING_OBSIDIAN_BRICKS.get(), FCBlocks.CRYING_OBSIDIAN_BRICK_STAIRS.get(), FCBlocks.CRYING_OBSIDIAN_BRICK_SLAB.get(), FCBlocks.CRYING_OBSIDIAN_BRICK_WALL.get());
        this.groupSSW(FCBlocks.POLISHED_OBSIDIAN.get(), FCBlocks.POLISHED_OBSIDIAN_STAIRS.get(), FCBlocks.POLISHED_OBSIDIAN_SLAB.get(), FCBlocks.POLISHED_OBSIDIAN_WALL.get());
        this.groupSSW(FCBlocks.CRYING_POLISHED_OBSIDIAN.get(), FCBlocks.CRYING_POLISHED_OBSIDIAN_STAIRS.get(), FCBlocks.CRYING_POLISHED_OBSIDIAN_SLAB.get(), FCBlocks.CRYING_POLISHED_OBSIDIAN_WALL.get());
    }

    public void groupSSW(Block parent, Block stairs, Block slab, Block wall) {
        this.block(parent);
        this.stairs(stairs, parent);
        this.slab(slab, parent);
        this.wall(wall, parent);
    }

    public void block(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
        this.blockItem(block);
    }

    public void pillarBlock(Block pillar) {
        this.logBlock((RotatedPillarBlock)pillar);
        this.blockItem(pillar);
    }

    public void stairs(Block stairs, Block parent) {
        this.stairsBlock((StairBlock)stairs, this.blockTexture(parent));
        this.blockItem(stairs);
    }

    public void slab(Block slab, Block parent) {
        this.slabBlock((SlabBlock)slab, this.blockTexture(parent), this.blockTexture(parent));
        this.blockItem(slab);
    }

    public void wall(Block wall, Block parent) {
        this.wallBlock((WallBlock)wall, this.blockTexture(parent));
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name(wall))).parent((ModelFile)this.models().wallInventory(this.name(wall) + "_inventory", this.blockTexture(parent)));
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
    }

    private String name(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
    }
}

