/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core.other;

import com.davigj.frame_changer.core.other.FCConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.spelunkery.reg.ModItems;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FCDataMapUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"frame_changer");
    public static final DataMapType<Block, CryingData> CRYING_CONVERTS = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frame_changer", (String)"crying_converts"), (ResourceKey)Registries.BLOCK, CryingData.CODEC).build();
    public static final DataMapType<Block, CryingData> SPELUNKERY_PORTAL_FLUID_DRAIN_CONVERTS = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frame_changer", (String)"spelunkery_portal_fluid_drain_converts"), (ResourceKey)Registries.BLOCK, CryingData.CODEC).build();

    private static Supplier<Block> getConversionBlock(String fullId) {
        String[] parts = fullId.split(":");
        if (parts.length != 2) {
            LOGGER.warn("Improperly formatted config for crying conversion block. String should be formatted 'modID:blockID'. Defaulting to minecraft:crying_obsidian");
            return () -> Blocks.CRYING_OBSIDIAN;
        }
        String modid = parts[0];
        String blockID = parts[1];
        if (!ModList.get().isLoaded(modid) && modid != null) {
            LOGGER.warn("Mod '" + modid + "' not loaded, invalid crying conversion blockID. String should be formatted 'modID:blockID'. Defaulting to minecraft:crying_obsidian");
            return () -> Blocks.CRYING_OBSIDIAN;
        }
        assert (modid != null);
        ResourceLocation block = ResourceLocation.fromNamespaceAndPath((String)modid, (String)blockID);
        if (BuiltInRegistries.BLOCK.get(block) == Blocks.AIR) {
            LOGGER.warn("Invalid crying conversion blockID. String should be formatted 'modID:blockID'. Defaulting to minecraft:crying_obsidian");
            return () -> Blocks.CRYING_OBSIDIAN;
        }
        return ModList.get().isLoaded(modid) ? () -> (Block)BuiltInRegistries.BLOCK.get(block) : () -> null;
    }

    public static void fluidSpread(BlockState state, Level level, BlockPos pos, double cryChance) {
        Direction.Axis axis2 = (Direction.Axis)state.getValue((Property)NetherPortalBlock.AXIS);
        RandomSource random = level.getRandom();
        for (Direction cryDir : Direction.values()) {
            BlockState cryState = level.getBlockState(pos.relative(cryDir));
            Holder holder = cryState.getBlockHolder();
            CryingData data = (CryingData)holder.getData(CRYING_CONVERTS);
            if (data == null || !(random.nextDouble() < cryChance) || new PortalShape((LevelAccessor)level, pos, axis2).isComplete()) continue;
            BlockState convertedState = BlockUtil.transferAllBlockStates((BlockState)cryState, (BlockState)FCDataMapUtil.getConversionBlock(data.result).get().defaultBlockState());
            if (ModList.get().isLoaded("spelunkery")) {
                if (FCConstants.spelunkeryCryingPortals && cryState.is(Blocks.OBSIDIAN)) continue;
                level.setBlock(pos.relative(cryDir), convertedState, 3);
                continue;
            }
            level.setBlock(pos.relative(cryDir), convertedState, 3);
        }
    }

    public static void fluidDrain(Player player, BlockState clickedBlockState, ItemStack heldItem, PlayerInteractEvent.RightClickBlock event) {
        Holder holder = clickedBlockState.getBlockHolder();
        CryingData data = (CryingData)holder.getData(SPELUNKERY_PORTAL_FLUID_DRAIN_CONVERTS);
        if (data != null && heldItem.is(Items.GLASS_BOTTLE)) {
            BlockState convertedState = BlockUtil.transferAllBlockStates((BlockState)clickedBlockState, (BlockState)FCDataMapUtil.getConversionBlock(data.result).get().defaultBlockState());
            player.level().setBlock(event.getPos(), convertedState, 3);
            player.swing(event.getHand());
            event.setCancellationResult(InteractionResult.SUCCESS);
            ItemStack portalFluid = new ItemStack((ItemLike)ModItems.PORTAL_FLUID_BOTTLE.get());
            player.level().playSound(player, event.getPos(), (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.spawnParticlesOnBlockFaces((Level)player.level(), (BlockPos)event.getPos(), (ParticleOptions)ParticleTypes.FALLING_OBSIDIAN_TEAR, (IntProvider)UniformInt.of((int)3, (int)5));
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
                if (!player.getInventory().add(portalFluid)) {
                    player.drop(portalFluid, false);
                }
            }
        }
    }

    public record CryingData(String result) {
        public static final Codec<CryingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("result").forGetter(CryingData::result)).apply((Applicative)instance, CryingData::new));
    }
}

