/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FCConfig {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> portalFrameTag;
        public final ForgeConfigSpec.ConfigValue<Boolean> customExitPortals;
        public final ForgeConfigSpec.ConfigValue<String> exitPortalFrame;
        public final ForgeConfigSpec.ConfigValue<Boolean> contagiousMisery;
        public final ForgeConfigSpec.ConfigValue<Double> convertChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("changes");
            builder.push("custom portal frames");
            this.portalFrameTag = builder.comment("Nether portal frames can be made of anything in the blocktag frame_changer:portal_frames").define("Nether portal frame variety", true);
            builder.pop();
            builder.push("custom exit portals");
            this.customExitPortals = builder.comment("Entering a portal causes the portal on the other side to be made of a custom block").define("Custom exit portals", false);
            this.exitPortalFrame = builder.comment("Define the block that exit portal frames are made of. Format should follow 'modid:blockID'. Ideally, the block should also be a valid portal frame.").define("Exit portal frame", (Object)"minecraft:obsidian");
            builder.pop();
            builder.push("portal break changes");
            this.contagiousMisery = builder.comment("Breaking a portal causes obsidian blocks in the frame to possibly convert to their crying variants").define("Contagious misery", false);
            this.convertChance = builder.comment("Chance of broken portals turning obsidian blocks into their crying variants. Takes in a double value.").define("Crying conversion chance", (Object)0.33);
            builder.pop();
            builder.pop();
        }
    }
}

