/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core.mixin;

import com.davigj.frame_changer.core.FCConfig;
import com.davigj.frame_changer.core.other.FCConstants;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NetherPortalBlock.class})
public class NetherPortalBlockMixin {
    @Inject(method={"updateShape"}, at={@At(value="HEAD")})
    private void updateObby(BlockState state, Direction dir, BlockState nextState, LevelAccessor level, BlockPos pos, BlockPos nextPos, CallbackInfoReturnable<BlockState> cir) {
        if (!level.m_5776_()) {
            if (ModList.get().isLoaded("spelunkery")) {
                if (FCConstants.spelunkeryCryingPortals) {
                    this.framechanger$fluidSpread(state, (Level)level, pos, 0.33);
                }
            } else if (((Boolean)FCConfig.COMMON.contagiousMisery.get()).booleanValue()) {
                this.framechanger$fluidSpread(state, (Level)level, pos, (Double)FCConfig.COMMON.convertChance.get());
            }
        }
    }

    @Unique
    private void framechanger$fluidSpread(BlockState state, Level level, BlockPos pos, double cryChance) {
        Direction.Axis axis2 = (Direction.Axis)state.m_61143_((Property)NetherPortalBlock.f_54904_);
        RandomSource random = level.m_213780_();
        for (Direction cryDir : Direction.values()) {
            BlockState cryState = level.m_8055_(pos.m_121945_(cryDir));
            if (!(random.m_188500_() < cryChance) || !FCConstants.OBBY_MAP.containsKey(cryState.m_60734_()) || new PortalShape((LevelAccessor)level, pos, axis2).m_77744_()) continue;
            BlockState convertedState = BlockUtil.transferAllBlockStates((BlockState)cryState, (BlockState)FCConstants.OBBY_MAP.get(cryState.m_60734_()).m_49966_());
            if (ModList.get().isLoaded("spelunkery")) {
                if (FCConstants.spelunkeryCryingPortals && cryState.m_60713_(Blocks.f_50080_)) continue;
                level.m_7731_(pos.m_121945_(cryDir), convertedState, 3);
                continue;
            }
            level.m_7731_(pos.m_121945_(cryDir), convertedState, 3);
        }
    }
}

