/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.frame_changer.core.mixin;

import com.davigj.frame_changer.core.FCConfig;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PortalForcer.class})
public class PortalForcerMixin {
    @Unique
    private static final Logger framechanger$LOGGER = LogManager.getLogger((String)"frame_changer");
    @Mutable
    @Final
    @Shadow
    protected final ServerLevel f_77648_;

    public PortalForcerMixin(ServerLevel level) {
        this.f_77648_ = level;
    }

    @WrapOperation(method={"createPortal"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")})
    private boolean customExit(ServerLevel instance, BlockPos pos, BlockState state, Operation<Boolean> original, @Local(ordinal=3) int k3) {
        BlockState blockState = state;
        if (((Boolean)FCConfig.COMMON.customExitPortals.get()).booleanValue()) {
            blockState = k3 < 0 ? PortalForcerMixin.framechanger$getCompatBlock((String)FCConfig.COMMON.exitPortalFrame.get()).get().m_49966_() : Blocks.f_50016_.m_49966_();
        }
        return (Boolean)original.call(new Object[]{instance, pos, blockState});
    }

    @WrapOperation(method={"createPortal"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", ordinal=0)})
    private boolean customExitPt2(ServerLevel instance, BlockPos pos, BlockState state, int i, Operation<Boolean> original) {
        BlockState blockState = state;
        if (((Boolean)FCConfig.COMMON.customExitPortals.get()).booleanValue()) {
            blockState = PortalForcerMixin.framechanger$getCompatBlock((String)FCConfig.COMMON.exitPortalFrame.get()).get().m_49966_();
        }
        return (Boolean)original.call(new Object[]{instance, pos, blockState, i});
    }

    @Unique
    private static Supplier<Block> framechanger$getCompatBlock(String fullId) {
        String[] parts = fullId.split(":");
        if (parts.length != 2) {
            framechanger$LOGGER.warn("Improperly formatted config for generated portal frames. Current input: " + fullId + ". String should be formatted 'modid:blockID'. Defaulting to minecraft:obsidian");
            return () -> Blocks.f_50080_;
        }
        String modid = parts[0];
        String blockID = parts[1];
        if (!ModList.get().isLoaded(modid) && modid != null) {
            framechanger$LOGGER.warn("Mod '" + modid + "' not loaded, invalid configured exit portal frame blockID. Current input: " + fullId + ". String should be formatted 'modID:blockID'. Defaulting to minecraft:obsidian");
            return () -> Blocks.f_50080_;
        }
        assert (modid != null);
        ResourceLocation block = new ResourceLocation(modid, blockID);
        if (ForgeRegistries.BLOCKS.getValue(block) == Blocks.f_50016_) {
            framechanger$LOGGER.warn("Invalid configured exit portal frame blockID. Current input: " + fullId + ". String should be formatted 'modID:blockID'. Defaulting to minecraft:obsidian");
            return () -> Blocks.f_50080_;
        }
        return ModList.get().isLoaded(modid) ? () -> (Block)ForgeRegistries.BLOCKS.getValue(block) : () -> null;
    }
}

