/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.mixin.PonderTagRegistryAccessor;
import com.almostreliable.ponderjs.util.PonderPlatform;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.ponder.api.registration.MultiTagBuilder;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.createmod.ponder.foundation.PonderTag;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PonderItemTagEventJS
extends EventJS {
    private final PonderTagRegistrationHelper<ResourceLocation> helper;

    public PonderItemTagEventJS(PonderTagRegistrationHelper<ResourceLocation> helper) {
        this.helper = helper;
    }

    public void createTag(String id, Item displayItem, String title, String description, @Nullable Ingredient ingredient) {
        ResourceLocation idWithNamespace = PonderJS.appendKubeToId(id);
        this.helper.registerTag(idWithNamespace).item((ItemLike)displayItem).title(title).description(description).register();
        if (ingredient != null) {
            MultiTagBuilder.Tag tags = this.helper.addToTag(idWithNamespace);
            for (ItemStack item : ingredient.m_43908_()) {
                ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
                tags.add((Object)itemId);
            }
        }
        PonderJS.NAMESPACES.add(idWithNamespace.m_135827_());
    }

    public void createTag(String id, Item displayItem, String title, String description) {
        this.createTag(id, displayItem, title, description, null);
    }

    public void add(PonderTag tag, Ingredient ingredient) {
        if (ingredient.m_43947_()) {
            return;
        }
        MultiTagBuilder.Tag tagBuilder = this.helper.addToTag(tag.getId());
        for (ItemStack item : ingredient.m_43908_()) {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
            tagBuilder.add((Object)id);
        }
    }

    public void removeTag(PonderTag ... tagsToRemove) {
        if (tagsToRemove.length == 0) {
            return;
        }
        PonderTagRegistryAccessor reg = PonderJS.getTagRegistryAccessor();
        for (PonderTag tag : tagsToRemove) {
            if (tag.equals((Object)reg.getMissing())) continue;
            reg.getRegisteredTags().remove(tag.getId());
            reg.getListedTags().remove(tag);
            this.remove(tag, PonderJS.getTagRegistry().getItems(tag));
        }
    }

    public void remove(PonderTag tag, Ingredient ingredient) {
        if (ingredient.m_43947_()) {
            return;
        }
        Set<ResourceLocation> ids = Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).map(PonderPlatform::getItemName).collect(Collectors.toSet());
        this.remove(tag, ids);
    }

    private void remove(PonderTag tag, Set<ResourceLocation> items) {
        PonderTagRegistryAccessor reg = PonderJS.getTagRegistryAccessor();
        for (ResourceLocation item : items) {
            if (!reg.getComponentTagMap().get((Object)item).remove(tag.getId())) continue;
            ConsoleJS.CLIENT.info((Object)("Removed ponder tag " + String.valueOf(tag.getId()) + " from item " + String.valueOf(item)));
        }
    }
}

