/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.state;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thepoultryman.arrp_but_different.json.state.JMultipart;
import io.github.thepoultryman.arrp_but_different.json.state.JVariant;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JState {
    private final List<JVariant> variants = new ArrayList<JVariant>();
    private final List<JMultipart> multiparts = new ArrayList<JMultipart>();

    public JState() {
    }

    public JState(JVariant ... variants) {
        JState state = new JState();
        state.addAll(variants);
    }

    public JState(JMultipart ... parts) {
        JState state = new JState();
        state.addAll(parts);
    }

    public JState add(JVariant variant) {
        if (!this.multiparts.isEmpty()) {
            throw new IllegalStateException("BlockStates are not allowed to have both multiparts and variants.");
        }
        this.variants.add(variant);
        return this;
    }

    public JState add(JMultipart part) {
        if (!this.variants.isEmpty()) {
            throw new IllegalStateException("BlockStates are not allowed to have both multiparts and variants.");
        }
        this.multiparts.add(part);
        return this;
    }

    public JState addAll(JVariant ... variants) {
        if (!this.multiparts.isEmpty()) {
            throw new IllegalStateException("BlockStates are not allowed to have both multiparts and variants.");
        }
        this.variants.addAll(List.of(variants));
        return this;
    }

    public JState addAll(JMultipart ... parts) {
        if (!this.variants.isEmpty()) {
            throw new IllegalStateException("BlockStates are not allowed to have both multiparts and variants.");
        }
        this.multiparts.addAll(List.of(parts));
        return this;
    }

    public JState clone() {
        try {
            return (JState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class Serializer
    implements JsonSerializer<JState> {
        public JsonElement serialize(JState src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (!src.variants.isEmpty()) {
                JsonObject variants = new JsonObject();
                src.variants.forEach(variant -> variants.add(String.join((CharSequence)",", variant.conditions), context.serialize((Object)variant.model)));
                jsonObject.add("variants", (JsonElement)variants);
            }
            if (!src.multiparts.isEmpty()) {
                jsonObject.add("multipart", context.serialize(src.multiparts));
            }
            return jsonObject;
        }
    }
}

