/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class JLang
implements Cloneable {
    private final Map<String, String> lang = new HashMap<String, String>();

    public static JLang lang() {
        return new JLang();
    }

    private <T> JLang addObject(Registry<T> registry, String string, T registryObject, String name) {
        return this.addObject(string, Objects.requireNonNull(registry.getKey(registryObject), "Your item should be registered before you call this method"), name);
    }

    private JLang addObject(String type, ResourceLocation resourceLocation, String translation) {
        this.lang.put(type + "." + resourceLocation.getNamespace() + "." + resourceLocation.getPath(), translation);
        return this;
    }

    public JLang addEntry(String entry, String name) {
        this.lang.put(entry, name);
        return this;
    }

    public JLang addItemTranslation(Item item, String name) {
        this.lang.put(item.getDescriptionId(), name);
        return this;
    }

    public JLang addItemTranslation(ItemStack itemStack, String name) {
        this.lang.put(itemStack.getItem().getDescriptionId(), name);
        return this;
    }

    public JLang addItemTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("item", resourceLocation, name);
    }

    public JLang addBlockTranslation(Block block, String name) {
        this.lang.put(block.getDescriptionId(), name);
        return this;
    }

    public JLang addBlockTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("block", resourceLocation, name);
    }

    public JLang addFluidTranslation(Fluid fluid, String name) {
        this.addObject((Registry)BuiltInRegistries.FLUID, "fluid", (Object)fluid, name);
        return this;
    }

    public JLang addFluidTranslation(ResourceLocation resourceLocation, String name) {
        this.addObject("fluid", resourceLocation, name);
        return this;
    }

    public JLang addEntityTranslation(EntityType<?> type, String name) {
        this.lang.put(type.getDescriptionId(), name);
        return this;
    }

    public JLang addEntityTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("entity_type", resourceLocation, name);
    }

    public JLang addEnchantmentTranslation(Enchantment enchantment, String name) {
        return this;
    }

    public JLang addItemGroupTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("itemGroup", resourceLocation, name);
    }

    public JLang addSoundTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("sound_event", resourceLocation, name);
    }

    public JLang addStatusTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("mob_effect", resourceLocation, name);
    }

    public JLang addAllPotionTranslations(ResourceLocation resourceLocation, String drinkablePotionName, String splashPotionName, String lingeringPotionName, String tippedArrowName) {
        return this.addDrinkablePotionTranslation(resourceLocation, drinkablePotionName).addSplashPotionTranslation(resourceLocation, splashPotionName).addLingeringPotionTranslation(resourceLocation, lingeringPotionName).addTippedArrowTranslation(resourceLocation, tippedArrowName);
    }

    public JLang addDrinkablePotionTranslation(ResourceLocation resourceLocation, String name) {
        this.lang.put("item.minecraft.potion.effect." + resourceLocation.getPath(), name);
        return this;
    }

    public JLang addSplashPotionTranslation(ResourceLocation resourceLocation, String name) {
        this.lang.put("item.minecraft.splash_potion.effect." + resourceLocation.getPath(), name);
        return this;
    }

    public JLang addLingeringPotionTranslation(ResourceLocation resourceLocation, String name) {
        this.lang.put("item.minecraft.lingering_potion.effect" + resourceLocation.getPath(), name);
        return this;
    }

    public JLang addTippedArrowTranslation(ResourceLocation resourceLocation, String name) {
        this.lang.put("item.minecraft.tipped_arrow.effect." + resourceLocation.getPath(), name);
        return this;
    }

    public JLang addBiomeTranslation(ResourceLocation resourceLocation, String name) {
        return this.addObject("biome", resourceLocation, name);
    }

    public Map<String, String> getLang() {
        return this.lang;
    }

    public JLang clone() {
        try {
            return (JLang)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

