/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thepoultryman.arrp_but_different.json.JsonUtil;
import io.github.thepoultryman.arrp_but_different.json.loot.JPool;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public class JLootTable {
    private final String type;
    private List<JPool> pools;
    private List<LootItemFunction> functions;

    public JLootTable(String type) {
        this.type = type;
    }

    public JLootTable pool(JPool pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<JPool>();
        }
        this.pools.add(pool);
        return this;
    }

    public JLootTable function(LootItemFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<LootItemFunction>();
        }
        this.functions.add(function);
        return this;
    }

    public static class Serializer
    implements JsonSerializer<JLootTable> {
        public JsonElement serialize(JLootTable src, Type type, JsonSerializationContext context) {
            JsonObject lootTable = new JsonObject();
            lootTable.addProperty("type", src.type);
            if (src.pools != null) {
                lootTable.add("pools", context.serialize(src.pools));
            }
            if (src.functions != null) {
                lootTable.add("functions", (JsonElement)JsonUtil.serializeCodecList(src.functions, LootItemFunctions.TYPED_CODEC));
            }
            return lootTable;
        }
    }
}

