/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.state;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.properties.Property;

public class JWhen
implements Cloneable {
    private final List<List<Tuple<String, String[]>>> state = new ArrayList<List<Tuple<String, String[]>>>();

    @SafeVarargs
    public final <T extends Comparable<T>> JWhen add(Property<T> property, T ... values) {
        String[] states = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            states[i] = property.getName(values[i]);
        }
        return this.add(property.getName(), states);
    }

    public JWhen add(String condition, String ... states) {
        this.state.add(List.of(new Tuple((Object)condition, (Object)states)));
        return this;
    }

    public JWhen clone() {
        try {
            return (JWhen)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class Serializer
    implements JsonSerializer<JWhen> {
        public JsonElement serialize(JWhen src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.state.size() == 1) {
                JsonObject jsonObject = new JsonObject();
                for (Tuple<String, String[]> stringTuple : src.state.getFirst()) {
                    jsonObject.addProperty((String)stringTuple.getA(), String.join((CharSequence)"|", (CharSequence[])stringTuple.getB()));
                }
                return jsonObject;
            }
            JsonObject mainJson = new JsonObject();
            JsonArray array = new JsonArray();
            for (List<Tuple<String, String[]>> tuples : src.state) {
                JsonObject jsonObject = new JsonObject();
                for (Tuple<String, String[]> tuple : tuples) {
                    jsonObject.addProperty((String)tuple.getA(), String.join((CharSequence)"|", (CharSequence[])tuple.getB()));
                }
                array.add((JsonElement)jsonObject);
            }
            mainJson.add("OR", (JsonElement)array);
            return mainJson;
        }
    }

    public static class StateBuilder
    implements Cloneable {
        final List<Tuple<String, String[]>> state = new ArrayList<Tuple<String, String[]>>();

        @SafeVarargs
        public final <T extends Comparable<T>> StateBuilder add(Property<T> property, T ... values) {
            String[] states = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                states[i] = property.getName(values[i]);
            }
            return this.add(property.getName(), states);
        }

        public StateBuilder add(String condition, String ... states) {
            this.state.add((Tuple<String, String[]>)new Tuple((Object)condition, (Object)states));
            return this;
        }

        public StateBuilder clone() {
            try {
                return (StateBuilder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }
}

