/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.thepoultryman.arrp_but_different.ARRPCommon;
import io.github.thepoultryman.arrp_but_different.ARRPConfig;
import io.github.thepoultryman.arrp_but_different.api.RuntimeResourcePack;
import io.github.thepoultryman.arrp_but_different.json.JCondition;
import io.github.thepoultryman.arrp_but_different.json.JLang;
import io.github.thepoultryman.arrp_but_different.json.JTag;
import io.github.thepoultryman.arrp_but_different.json.advancement.JAdvancement;
import io.github.thepoultryman.arrp_but_different.json.animation.JAnimation;
import io.github.thepoultryman.arrp_but_different.json.loot.JLootTable;
import io.github.thepoultryman.arrp_but_different.json.loot.JPool;
import io.github.thepoultryman.arrp_but_different.json.model.JModel;
import io.github.thepoultryman.arrp_but_different.json.model.JTextures;
import io.github.thepoultryman.arrp_but_different.json.recipe.AbstractJRecipe;
import io.github.thepoultryman.arrp_but_different.json.recipe.JIngredient;
import io.github.thepoultryman.arrp_but_different.json.recipe.banner.JBannerPatternType;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JBannerPatternsComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JBeesComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JCodecBuilderComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JCodecComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JColorComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JContainerComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JCustomDataComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JDyedColorComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JEnchantmentsComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JItemListComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JListComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JMultitypeComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JSimpleComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JStringMapComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.JWritableBookContentComponent;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.consumable.JSound;
import io.github.thepoultryman.arrp_but_different.json.serializers.AdvancementRewardsSerializer;
import io.github.thepoultryman.arrp_but_different.json.serializers.CodecSerializer;
import io.github.thepoultryman.arrp_but_different.json.serializers.CriterionSerializer;
import io.github.thepoultryman.arrp_but_different.json.serializers.DisplayInfoSerializer;
import io.github.thepoultryman.arrp_but_different.json.serializers.ResourceLocationSerializer;
import io.github.thepoultryman.arrp_but_different.json.state.JMultipart;
import io.github.thepoultryman.arrp_but_different.json.state.JState;
import io.github.thepoultryman.arrp_but_different.json.state.JWhen;
import io.github.thepoultryman.arrp_but_different.util.CountingInputStream;
import io.github.thepoultryman.arrp_but_different.util.UnsafeByteArrayOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeResourcePackImpl
implements RuntimeResourcePack {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(AdvancementRewards.class, (Object)new AdvancementRewardsSerializer()).registerTypeAdapter(Component.class, new CodecSerializer(ComponentSerialization.CODEC)).registerTypeAdapter(Criterion.class, (Object)new CriterionSerializer()).registerTypeAdapter(DisplayInfo.class, (Object)new DisplayInfoSerializer()).registerTypeAdapter(JAnimation.class, (Object)new JAnimation.Serializer()).registerTypeAdapter(JBannerPatternType.class, (Object)new JBannerPatternType.Serializer()).registerTypeAdapter(JBannerPatternsComponent.class, (Object)new JBannerPatternsComponent.Serializer()).registerTypeAdapter(JBeesComponent.BeeData.class, (Object)new JBeesComponent.BeeData.Serializer()).registerTypeAdapter(JBeesComponent.class, (Object)new JBeesComponent.Serializer()).registerTypeAdapter(JCodecBuilderComponent.class, new JCodecBuilderComponent.Serializer()).registerTypeAdapter(JCodecComponent.class, new JCodecComponent.Serializer()).registerTypeAdapter(JColorComponent.class, (Object)new JColorComponent.Serializer()).registerTypeAdapter(JCondition.class, (Object)new JCondition.Serializer()).registerTypeAdapter(JContainerComponent.class, (Object)new JContainerComponent.Serializer()).registerTypeAdapter(JCustomDataComponent.class, (Object)new JCustomDataComponent.Serializer()).registerTypeAdapter(JDyedColorComponent.class, (Object)new JDyedColorComponent.Serializer()).registerTypeAdapter(JEnchantmentsComponent.class, (Object)new JEnchantmentsComponent.Serializer()).registerTypeAdapter(JIngredient.class, (Object)new JIngredient.Serializer()).registerTypeAdapter(JItemListComponent.class, (Object)new JItemListComponent.Serializer()).registerTypeAdapter(JListComponent.class, (Object)new JListComponent.Serializer()).registerTypeAdapter(JLootTable.class, (Object)new JLootTable.Serializer()).registerTypeAdapter(JMultipart.class, (Object)new JMultipart.Serializer()).registerTypeAdapter(JMultitypeComponent.class, (Object)new JMultitypeComponent.Serializer()).registerTypeAdapter(JPool.class, (Object)new JPool.Serializer()).registerTypeAdapter(JSimpleComponent.class, (Object)new JSimpleComponent.Serializer()).registerTypeAdapter(JSound.class, (Object)new JSound.Serializer()).registerTypeAdapter(JState.class, (Object)new JState.Serializer()).registerTypeAdapter(JStringMapComponent.class, (Object)new JStringMapComponent.Serializer()).registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JWhen.class, (Object)new JWhen.Serializer()).registerTypeAdapter(JWritableBookContentComponent.class, (Object)new JWritableBookContentComponent.Serializer()).registerTypeAdapter(MutableComponent.class, new CodecSerializer(ComponentSerialization.CODEC)).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationSerializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Set<String> KEY_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ResourceLocation id;
    private final PackLocationInfo info;
    private final Lock lock = new ReentrantLock();
    private final Map<ResourceLocation, Supplier<byte[]>> assets = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    private final Map<ResourceLocation, JLang> langMergeable = new ConcurrentHashMap<ResourceLocation, JLang>();

    public RuntimeResourcePackImpl(ResourceLocation resourceLocation) {
        this.id = resourceLocation;
        this.info = new PackLocationInfo(this.id.getNamespace() + ";" + this.id.getPath(), (Component)Component.literal((String)("Runtime Resource Pack for " + String.valueOf(this.id))), PackSource.DEFAULT, Optional.empty());
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... pElements) {
        this.lock();
        Supplier<byte[]> byteArraySupplier = this.root.get(Arrays.asList(pElements));
        if (byteArraySupplier == null) {
            this.lock.unlock();
            return null;
        }
        this.lock.unlock();
        return () -> new ByteArrayInputStream((byte[])byteArraySupplier.get());
    }

    @Nullable
    public IoSupplier<InputStream> getResource(@NotNull PackType pPackType, @NotNull ResourceLocation pLocation) {
        this.lock();
        Supplier<byte[]> byteArraySupplier = this.getSys(pPackType).get(pLocation);
        if (byteArraySupplier == null) {
            this.lock.unlock();
            return null;
        }
        this.lock.unlock();
        return () -> new ByteArrayInputStream((byte[])byteArraySupplier.get());
    }

    public void listResources(@NotNull PackType pPackType, @NotNull String pNamespace, @NotNull String pPath, @NotNull PackResources.ResourceOutput pResourceOutput) {
        this.lock();
        for (ResourceLocation resourceLocation : this.getSys(pPackType).keySet()) {
            Supplier<byte[]> byteArraySupplier = this.getSys(pPackType).get(resourceLocation);
            if (byteArraySupplier == null) {
                this.lock.unlock();
                continue;
            }
            IoSupplier ioSupplier = () -> new ByteArrayInputStream((byte[])byteArraySupplier.get());
            if (!resourceLocation.getNamespace().equals(pNamespace) || !resourceLocation.getPath().startsWith(pPath)) continue;
            pResourceOutput.accept((Object)resourceLocation, (Object)ioSupplier);
        }
        this.lock.unlock();
    }

    @NotNull
    public Set<String> getNamespaces(@NotNull PackType pType) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation resourceLocation : this.getSys(pType).keySet()) {
            namespaces.add(resourceLocation.getNamespace());
        }
        this.lock.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T getMetadataSection(@NotNull MetadataSectionType<T> pSectionType) {
        return this.getMetadataSection(pSectionType, null);
    }

    @Nullable
    public <T> T getMetadataSection(@NotNull MetadataSectionType<T> pSectionType, PackFormat packFormat) {
        InputStream inputStream = null;
        try {
            IoSupplier<InputStream> ioSupplier = this.getRootResource("pack.mcmeta");
            if (ioSupplier != null) {
                inputStream = (InputStream)ioSupplier.get();
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        if (inputStream != null) {
            return (T)AbstractPackResources.getMetadataFromStream(pSectionType, (InputStream)inputStream, (PackLocationInfo)this.info);
        }
        if (pSectionType.name().equals("pack")) {
            DataResult result = pSectionType.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)RuntimeResourcePackImpl.createPackMeta(packFormat));
            if (result.isSuccess()) {
                return (T)result.getOrThrow();
            }
            result.getOrThrow();
            throw new RuntimeException("Resource Pack information could not be parsed.");
        }
        if (this.KEY_WARNINGS.add(pSectionType.name())) {
            ARRPCommon.LOGGER.debug("\"{}\" is an unsupported metadata key", (Object)pSectionType.name());
        }
        return null;
    }

    private static JsonObject createPackMeta(PackFormat packFormat) {
        JsonObject object = new JsonObject();
        if (packFormat != null) {
            object.addProperty("min_format", (Number)packFormat.major());
            object.addProperty("max_format", (Number)packFormat.major());
        }
        object.addProperty("description", "runtime resource pack");
        return object;
    }

    @NotNull
    public PackLocationInfo location() {
        return this.info;
    }

    public void close() {
        ARRPCommon.LOGGER.info("Closing Runtime Resource Pack {}", (Object)this.id);
        if (ARRPConfig.dump) {
            this.lock();
            this.dump();
            this.lock.unlock();
        }
    }

    private void write(Path dir, ResourceLocation identifier, byte[] data) {
        block9: {
            try {
                String namespace = identifier.getNamespace();
                String path = identifier.getPath();
                Path file = dir.resolve(namespace).resolve(path);
                if (file.toAbsolutePath().startsWith(dir.toAbsolutePath())) {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                        output.write(data);
                        break block9;
                    }
                }
                ARRPCommon.LOGGER.error("RRP contains out-of-directory location! \"{}/{}\"", (Object)namespace, (Object)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void dump() {
        ARRPCommon.LOGGER.info("Dumping generated resources for \"{}\"", (Object)this.id);
        Path output = Path.of(ARRPConfig.dumpDirectory, new String[0]);
        try {
            for (Map.Entry<List<String>, Supplier<byte[]>> e : this.root.entrySet()) {
                String string = String.join((CharSequence)"/", (Iterable<? extends CharSequence>)e.getKey());
                Path path = output.resolve(string);
                if (path.toAbsolutePath().startsWith(output.toAbsolutePath())) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(path, (byte[])((Supplier)e.getValue()).get(), new OpenOption[0]);
                    continue;
                }
                ARRPCommon.LOGGER.error("RRP contains out-of-directory path! \"{}\"", (Object)string);
            }
            Path assets = output.resolve("assets");
            Files.createDirectories(assets, new FileAttribute[0]);
            for (Map.Entry entry : this.assets.entrySet()) {
                this.write(assets, (ResourceLocation)entry.getKey(), (byte[])((Supplier)entry.getValue()).get());
            }
            Path data = output.resolve("data");
            Files.createDirectories(data, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(data, entry.getKey(), entry.getValue().get());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Map<ResourceLocation, Supplier<byte[]>> getSys(PackType packType) {
        return packType == PackType.CLIENT_RESOURCES ? this.assets : this.data;
    }

    private void lock() {
        if (!this.lock.tryLock()) {
            this.lock.lock();
        }
    }

    @Override
    public void addRecoloredImage(ResourceLocation resourceLocation, InputStream original, IntUnaryOperator pixel) {
        this.addLazyResource(PackType.CLIENT_RESOURCES, RuntimeResourcePackImpl.formatResourceLocation(resourceLocation, "textures", "png"), (runtimeResourcePack, resourceLocation1) -> {
            try {
                CountingInputStream countingInputStream = new CountingInputStream(original);
                BufferedImage base = ImageIO.read(original);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, pixel.applyAsInt(base.getRGB(x, y)));
                    }
                }
                UnsafeByteArrayOutputStream arrayOutputStream = new UnsafeByteArrayOutputStream(countingInputStream.bytes());
                ImageIO.write((RenderedImage)recolored, "png", arrayOutputStream);
                return arrayOutputStream.getBytes();
            }
            catch (Throwable e) {
                ARRPCommon.LOGGER.error("Error adding recolored image to runtime resource pack", e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(ResourceLocation resourceLocation, JLang lang) {
        return this.addAsset(RuntimeResourcePackImpl.formatResourceLocation(resourceLocation, "lang", "json"), RuntimeResourcePackImpl.serialize(lang.getLang()));
    }

    @Override
    public void mergeLang(ResourceLocation resourceLocation, JLang lang) {
        this.langMergeable.compute(resourceLocation, (location, language) -> {
            if (language == null) {
                JLang result = language = new JLang();
                this.addLazyResource(PackType.CLIENT_RESOURCES, resourceLocation, (resourcePack, packLocation) -> resourcePack.addLang(resourceLocation, result));
            }
            language.getLang().putAll(lang.getLang());
            return language;
        });
    }

    @Override
    public byte[] addLootTable(ResourceLocation resourceLocation, JLootTable lootTable) {
        return this.addData(RuntimeResourcePackImpl.formatResourceLocation(resourceLocation, "loot_table", "json"), RuntimeResourcePackImpl.serialize(lootTable));
    }

    @Override
    public byte[] addAdvancement(ResourceLocation resourceLocation, JAdvancement advancement) {
        return this.addData(RuntimeResourcePackImpl.formatResourceLocation(resourceLocation, "advancement", "json"), RuntimeResourcePackImpl.serialize(advancement));
    }

    @Override
    public void addLazyResource(PackType packType, ResourceLocation path, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> data) {
        this.getSys(packType).put(path, new Memoized<ResourceLocation>(data, path));
    }

    @Override
    public byte[] addResource(PackType packType, ResourceLocation path, byte[] data) {
        this.getSys(packType).put(path, () -> data);
        return data;
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(List.of(path.split("/")), () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(ResourceLocation path, byte[] data) {
        return this.addResource(PackType.CLIENT_RESOURCES, path, data);
    }

    @Override
    public byte[] addData(ResourceLocation path, byte[] data) {
        return this.addResource(PackType.SERVER_DATA, path, data);
    }

    @Override
    public byte[] addModel(ResourceLocation path, JModel model) {
        return this.addAsset(RuntimeResourcePackImpl.formatResourceLocation(path, "models", "json"), RuntimeResourcePackImpl.serialize(model));
    }

    @Override
    public byte[] addBlockSate(ResourceLocation path, JState state) {
        return this.addAsset(RuntimeResourcePackImpl.formatResourceLocation(path, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    public byte[] addTexture(ResourceLocation path, BufferedImage image) {
        UnsafeByteArrayOutputStream byteArrayOutputStream = new UnsafeByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.addAsset(RuntimeResourcePackImpl.formatResourceLocation(path, "textures", "png"), byteArrayOutputStream.getBytes());
    }

    @Override
    public byte[] addAnimation(ResourceLocation path, JAnimation animation) {
        return this.addAsset(RuntimeResourcePackImpl.formatResourceLocation(path, "textures", "png.mcmeta"), RuntimeResourcePackImpl.serialize(animation));
    }

    @Override
    public byte[] addTag(ResourceLocation path, JTag tag) {
        return this.addData(RuntimeResourcePackImpl.formatResourceLocation(path, "tags", "json"), RuntimeResourcePackImpl.serialize(tag));
    }

    @Override
    public byte[] addRecipe(ResourceLocation path, AbstractJRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.formatResourceLocation(path, "recipe", "json"), RuntimeResourcePackImpl.serialize(recipe));
    }

    @Override
    public void load(Path directory) throws IOException {
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(directory::relativize).iterator()) {
                String path;
                String string = file.toString();
                if (string.startsWith("assets")) {
                    path = string.substring("assets".length() + 1);
                    this.load(path, this.assets, Files.readAllBytes(file));
                    continue;
                }
                if (string.startsWith("data")) {
                    path = string.substring("data".length() + 1);
                    this.load(path, this.data, Files.readAllBytes(file));
                    continue;
                }
                byte[] data = Files.readAllBytes(file);
                this.root.put(List.of(string.split("/")), () -> data);
            }
        }
    }

    @Override
    public void load(ZipInputStream zipStream) throws IOException {
        ZipEntry entry;
        while ((entry = zipStream.getNextEntry()) != null) {
            String path;
            String string = entry.toString();
            if (string.startsWith("assets")) {
                path = string.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, zipStream));
                continue;
            }
            if (string.startsWith("data")) {
                path = string.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, zipStream));
                continue;
            }
            byte[] data = this.read(entry, zipStream);
            this.root.put(Arrays.asList(string.split("/")), () -> data);
        }
    }

    private void load(String fullPath, Map<ResourceLocation, Supplier<byte[]>> map, byte[] data) {
        int separatorIndex = fullPath.indexOf("/");
        String namespace = fullPath.substring(0, separatorIndex);
        String path = fullPath.substring(separatorIndex + 1);
        map.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), () -> data);
    }

    private byte[] read(ZipEntry entry, InputStream inputStream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (inputStream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off.");
        }
        return data;
    }

    public static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream byteArrayOutputStream = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.getBytes();
    }

    private static ResourceLocation formatResourceLocation(ResourceLocation resourceLocation, String prefix, String append) {
        return ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)(prefix + "/" + resourceLocation.getPath() + "." + append));
    }

    private class Memoized<T>
    implements Supplier<byte[]> {
        private final BiFunction<RuntimeResourcePack, T, byte[]> function;
        private final T path;
        private byte[] data;

        public Memoized(BiFunction<RuntimeResourcePack, T, byte[]> function, T path) {
            this.function = function;
            this.path = path;
        }

        @Override
        public byte[] get() {
            if (this.data == null) {
                this.data = this.function.apply(RuntimeResourcePackImpl.this, (RuntimeResourcePack)this.path);
            }
            return this.data;
        }
    }
}

