/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import io.github.thepoultryman.arrp_but_different.json.animation.JFrame;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JAnimation {
    private Boolean interpolate;
    private Integer width;
    private Integer height;
    @SerializedName(value="frametime")
    private Integer frameTime;
    private List<JFrame> frames;
    private List<Integer> defaultFrames;

    public JAnimation interpolate() {
        this.interpolate = true;
        return this;
    }

    public JAnimation width(int width) {
        this.width = width;
        return this;
    }

    public JAnimation height(int height) {
        this.height = height;
        return this;
    }

    public JAnimation frameTime(int time) {
        this.frameTime = time;
        return this;
    }

    public JAnimation add(int frame) {
        if (this.defaultFrames == null) {
            this.defaultFrames = new ArrayList<Integer>();
        }
        this.defaultFrames.add(frame);
        return this;
    }

    public JAnimation add(JFrame frame) {
        if (this.frames == null) {
            this.frames = new ArrayList<JFrame>();
        }
        this.frames.add(frame);
        return this;
    }

    public static class Serializer
    implements JsonSerializer<JAnimation> {
        public JsonElement serialize(JAnimation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            JsonObject animationJson = this.getAnimationJson(src);
            JsonArray frames = new JsonArray();
            if (src.frames != null) {
                for (JFrame frame : src.frames) {
                    frames.add(context.serialize((Object)frame));
                }
            }
            if (src.defaultFrames != null) {
                for (Integer defaultFrame : src.defaultFrames) {
                    frames.add((Number)defaultFrame);
                }
            }
            if (!frames.isEmpty()) {
                animationJson.add("frames", (JsonElement)frames);
            }
            jsonObject.add("animation", (JsonElement)animationJson);
            return jsonObject;
        }

        @NotNull
        private JsonObject getAnimationJson(JAnimation src) {
            JsonObject animationJson = new JsonObject();
            if (src.interpolate != null) {
                animationJson.addProperty("interpolate", src.interpolate);
            }
            if (src.width != null) {
                animationJson.addProperty("width", (Number)src.width);
            }
            if (src.height != null) {
                animationJson.addProperty("height", (Number)src.height);
            }
            if (src.frameTime != null) {
                animationJson.addProperty("frametime", (Number)src.frameTime);
            }
            return animationJson;
        }
    }
}

