/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import io.github.thepoultryman.arrp_but_different.json.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class JPool {
    private List<LootItemCondition> conditions;
    private List<LootItemFunction> functions;
    private List<LootPoolEntryContainer> entries;
    private NumberProvider rolls;
    @SerializedName(value="bonus_rolls")
    private NumberProvider bonusRolls;

    public JPool entry(LootPoolEntryContainer entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<LootPoolEntryContainer>();
        }
        this.entries.add(entry);
        return this;
    }

    public JPool condition(LootItemCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<LootItemCondition>();
        }
        this.conditions.add(condition);
        return this;
    }

    public JPool function(LootItemFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<LootItemFunction>();
        }
        this.functions.add(function);
        return this;
    }

    public JPool rolls(NumberProvider rolls) {
        this.rolls = rolls;
        return this;
    }

    public JPool bonusRolls(NumberProvider bonusRolls) {
        this.bonusRolls = bonusRolls;
        return this;
    }

    public static class Serializer
    implements JsonSerializer<JPool> {
        public JsonElement serialize(JPool src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.conditions != null) {
                jsonObject.add("conditions", (JsonElement)JsonUtil.serializeCodecList(src.conditions, LootItemCondition.TYPED_CODEC));
            }
            if (src.functions != null) {
                jsonObject.add("functions", (JsonElement)JsonUtil.serializeCodecList(src.functions, LootItemFunctions.TYPED_CODEC));
            }
            if (src.entries != null) {
                jsonObject.add("entries", (JsonElement)JsonUtil.serializeCodecList(src.entries, LootPoolEntries.CODEC));
            }
            if (src.rolls != null) {
                jsonObject.add("rolls", JsonUtil.serializeCodec(src.rolls, NumberProviders.CODEC));
            }
            if (src.bonusRolls != null) {
                jsonObject.add("bonus_rolls", JsonUtil.serializeCodec(src.bonusRolls, NumberProviders.CODEC));
            }
            return jsonObject;
        }
    }
}

