/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.recipe.component;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thepoultryman.arrp_but_different.json.recipe.component.AbstractJComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JMultitypeComponent
extends AbstractJComponent {
    private Type type;
    private Boolean booleanValue;
    private Double doubleValue;
    private String stringValue;
    private final List<JMultitypeComponent> listValue = new ArrayList<JMultitypeComponent>();
    private final HashMap<String, JMultitypeComponent> structValue = new HashMap();

    public JMultitypeComponent() {
    }

    public JMultitypeComponent(boolean booleanValue) {
        this.type = Type.Boolean;
        this.booleanValue = booleanValue;
    }

    public JMultitypeComponent(double doubleValue) {
        this.type = Type.Double;
        this.doubleValue = doubleValue;
    }

    public JMultitypeComponent(String stringValue) {
        this.type = Type.String;
        this.stringValue = stringValue;
    }

    public JMultitypeComponent addListValue(JMultitypeComponent value) {
        this.checkAndSetType(Type.List);
        this.listValue.add(value);
        return this;
    }

    public JMultitypeComponent addStructValue(String key, JMultitypeComponent value) {
        this.checkAndSetType(Type.Struct);
        this.structValue.put(key, value);
        return this;
    }

    private void checkAndSetType(Type type) {
        if (this.type == null) {
            this.type = type;
        } else if (this.type != type) {
            throw new IllegalStateException("A multitype component cannot have varying types within it. You are currently trying to use the" + String.valueOf((Object)type) + "type, but the current type is " + String.valueOf((Object)this.type));
        }
    }

    private static enum Type {
        Boolean,
        Double,
        String,
        List,
        Struct;

    }

    public static class Serializer
    implements JsonSerializer<JMultitypeComponent> {
        public JsonElement serialize(JMultitypeComponent src, java.lang.reflect.Type type, JsonSerializationContext context) {
            return switch (src.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> context.serialize((Object)src.booleanValue);
                case 1 -> context.serialize((Object)src.doubleValue);
                case 2 -> context.serialize((Object)src.stringValue);
                case 3 -> context.serialize(src.listValue);
                case 4 -> context.serialize(src.structValue);
            };
        }
    }
}

