/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.recipe.component;

import io.github.thepoultryman.arrp_but_different.json.recipe.component.JCodecBuilderComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.component.Tool;
import org.jetbrains.annotations.NotNull;

public class JToolComponent
extends JCodecBuilderComponent<Tool> {
    private final List<Tool.Rule> rules = new ArrayList<Tool.Rule>();
    private float defaultMiningSpeed;
    private int damagePerBlock;
    private boolean canDestroyBlocksInCreative;

    public JToolComponent() {
        super(Tool.CODEC);
        this.defaultMiningSpeed = 1.0f;
        this.damagePerBlock = 1;
        this.canDestroyBlocksInCreative = true;
    }

    public JToolComponent(@NotNull Tool tool) {
        super(Tool.CODEC);
        this.object = tool;
    }

    public JToolComponent defaultMiningSpeed(float speed) {
        this.defaultMiningSpeed = speed;
        return this;
    }

    public JToolComponent damagePerBlock(int damage) {
        this.damagePerBlock = damage;
        return this;
    }

    public JToolComponent canDestroyBlocksInCreative(boolean canDestroy) {
        this.canDestroyBlocksInCreative = canDestroy;
        return this;
    }

    public JToolComponent rule(Tool.Rule rule) {
        this.rules.add(rule);
        return this;
    }

    @Override
    protected Tool build() {
        if (this.object != null) {
            ((Tool)this.object).rules().addAll(this.rules);
        }
        return (Tool)super.build();
    }

    @Override
    public Tool manuallyBuild() {
        return new Tool(this.rules, this.defaultMiningSpeed, this.damagePerBlock, this.canDestroyBlocksInCreative);
    }
}

