/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.json.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.thepoultryman.arrp_but_different.json.JsonUtil;
import java.lang.reflect.Type;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.world.item.ItemStack;

public class DisplayInfoSerializer
implements JsonSerializer<DisplayInfo> {
    public JsonElement serialize(DisplayInfo src, Type type, JsonSerializationContext context) {
        JsonObject displayInfo = new JsonObject();
        displayInfo.add("icon", JsonUtil.serializeCodec(src.getIcon(), ItemStack.CODEC));
        displayInfo.add("title", context.serialize((Object)src.getTitle()));
        displayInfo.add("description", context.serialize((Object)src.getDescription()));
        displayInfo.add("frame", context.serialize((Object)src.getType().getSerializedName()));
        src.getBackground().ifPresent(background -> displayInfo.add("background", context.serialize((Object)background.id())));
        displayInfo.add("show_toast", context.serialize((Object)src.shouldShowToast()));
        displayInfo.add("announce_to_chat", context.serialize((Object)src.shouldAnnounceChat()));
        displayInfo.add("hidden", context.serialize((Object)src.isHidden()));
        return displayInfo;
    }
}

