/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.arrp_but_different.mixins;

import io.github.thepoultryman.arrp_but_different.ARRPCommon;
import io.github.thepoultryman.arrp_but_different.api.ARRPEventTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FolderRepositorySource.class})
public class FolderRepositorySourceMixin {
    @Shadow
    @Final
    private PackType packType;

    @Inject(at={@At(value="HEAD")}, method={"loadPacks"})
    private void arrp_neoforge$loadPacks(Consumer<Pack> pOnLoad, CallbackInfo ci) {
        ARRPCommon.LOGGER.info("Getting 'BeforeUser' packs");
        List<PackResources> packs = ARRPCommon.sendEvent(ARRPEventTypes.BeforeUser, new ArrayList<PackResources>());
        for (final PackResources pack : packs) {
            pOnLoad.accept(Pack.readMetaAndCreate((PackLocationInfo)pack.location(), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                @NotNull
                public PackResources openPrimary(@NotNull PackLocationInfo pLocation) {
                    return pack;
                }

                @NotNull
                public PackResources openFull(@NotNull PackLocationInfo pLocation, // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull Pack.Metadata pMetadata) {
                    return pack;
                }
            }, (PackType)this.packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false)));
        }
    }
}

