/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.capabilities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.silvertide.homebound.capabilities.IWarpCap;
import net.silvertide.homebound.capabilities.WarpPos;
import net.silvertide.homebound.util.CapabilityUtil;

public class WarpCap
implements IWarpCap {
    @Nullable
    private WarpPos warpPos;
    private int cooldown;
    private long lastWarpTimestamp;

    @Override
    public WarpPos getWarpPos() {
        return this.warpPos == null ? null : this.warpPos;
    }

    @Override
    public void setWarpPos(WarpPos warpPos) {
        this.warpPos = warpPos;
    }

    @Override
    public void setWarpPos(BlockPos pos, ResourceLocation dimension) {
        this.warpPos = new WarpPos(pos, dimension);
    }

    @Override
    public void setWarpPos(Player player) {
        this.warpPos = CapabilityUtil.createWarpPosOnPlayer(player);
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(long timestamp, int cooldown) {
        this.lastWarpTimestamp = timestamp;
        this.cooldown = Math.max(cooldown, 0);
    }

    @Override
    public void addCooldown(long currTime, int cooldown) {
        if (!this.hasCooldown(currTime)) {
            this.setCooldown(currTime, cooldown);
        } else {
            this.cooldown += cooldown;
        }
    }

    @Override
    public int getRemainingCooldown(long currTime) {
        return this.cooldown - (int)this.calculateTimePassed(currTime);
    }

    @Override
    public long getLastWarpTimestamp() {
        return this.lastWarpTimestamp;
    }

    @Override
    public boolean hasCooldown(long currTime) {
        return this.calculateTimePassed(currTime) < (long)this.cooldown;
    }

    @Override
    public void clearHome() {
        this.warpPos = null;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.warpPos != null) {
            nbt.m_128405_("xPos", this.warpPos.blockPos().m_123341_());
            nbt.m_128405_("yPos", this.warpPos.blockPos().m_123342_());
            nbt.m_128405_("zPos", this.warpPos.blockPos().m_123343_());
            nbt.m_128359_("dimension", this.warpPos.dimension().toString());
        }
        nbt.m_128405_("cooldown", this.getCooldown());
        nbt.m_128356_("lastUsedTimestamp", this.getLastWarpTimestamp());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("xPos") && nbt.m_128441_("dimension")) {
            this.setWarpPos(new BlockPos(nbt.m_128451_("xPos"), nbt.m_128451_("yPos"), nbt.m_128451_("zPos")), new ResourceLocation(nbt.m_128461_("dimension")));
        } else {
            this.clearHome();
        }
        this.setCooldown(nbt.m_128454_("lastUsedTimestamp"), nbt.m_128451_("cooldown"));
    }

    private long calculateTimePassed(long currTime) {
        return (currTime - this.lastWarpTimestamp) / 20L;
    }
}

