/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.silvertide.homebound.capabilities.IWarpCap;
import net.silvertide.homebound.capabilities.WarpCap;
import net.silvertide.homebound.registry.CapabilityRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpCapAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        WarpCapProvider provider = new WarpCapProvider();
        event.addCapability(WarpCapProvider.IDENTIFIER, (ICapabilityProvider)provider);
    }

    private static class WarpCapProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("homebound", "player_home");
        private final IWarpCap backend = new WarpCap();
        private final LazyOptional<IWarpCap> optionalData = LazyOptional.of(() -> this.backend);

        private WarpCapProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CapabilityRegistry.HOME_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT((Tag)nbt);
        }
    }
}

