/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.capabilities;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.silvertide.homebound.util.HomeboundUtil;

public record WarpPos(BlockPos blockPos, ResourceLocation dimension) {
    public int calculateDistance(WarpPos destination) {
        double xDelta = this.blockPos.m_123341_() - destination.blockPos.m_123341_();
        double yDelta = this.blockPos.m_123342_() - destination.blockPos.m_123342_();
        double zDelta = this.blockPos.m_123343_() - destination.blockPos.m_123343_();
        return (int)Math.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta);
    }

    public boolean isSameDimension(WarpPos destination) {
        return this.dimension.equals((Object)destination.dimension);
    }

    public boolean isSameDimension(ResourceLocation dimension) {
        return this.dimension.equals((Object)dimension);
    }

    @Override
    public String toString() {
        if (this.blockPos == null || this.dimension == null) {
            return "None";
        }
        String dimension = this.dimension.toString();
        String coords = "X: " + this.blockPos.m_123341_() + " Y: " + this.blockPos.m_123342_() + " Z: " + this.blockPos.m_123343_();
        String dimString = HomeboundUtil.formatDimension(dimension);
        return dimString + " - " + coords;
    }
}

