/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.client.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.silvertide.homebound.client.gui.ClientHomeData;
import net.silvertide.homebound.util.HomeboundUtil;

public class BindHomeBarOverlay
implements IGuiOverlay {
    private static final BindHomeBarOverlay instance = new BindHomeBarOverlay();
    public static final ResourceLocation TEXTURE = new ResourceLocation("homebound", "textures/gui/warp_bars.png");
    static final int IMAGE_WIDTH = 64;
    static final int IMAGE_HEIGHT = 9;
    static final int COMPLETION_BAR_WIDTH = 60;

    public static BindHomeBarOverlay get() {
        return instance;
    }

    public void render(ForgeGui gui, GuiGraphics guiHelper, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!ClientHomeData.isPlayerBindingHome() || minecraft.f_91073_ == null) {
            return;
        }
        long currentGameTime = minecraft.f_91073_.m_46467_();
        long totalWarpDurationInTicks = ClientHomeData.getFinishHomeTimeStamp() - ClientHomeData.getStartHomeTimeStamp();
        float warpCompletionPercent = (float)(currentGameTime - ClientHomeData.getStartHomeTimeStamp()) / (float)totalWarpDurationInTicks;
        int barX = screenWidth / 2 - 32;
        int barY = screenHeight / 2 + screenHeight / 6;
        guiHelper.m_280163_(TEXTURE, barX, barY, 0.0f, 0.0f, 64, 9, 256, 256);
        guiHelper.m_280218_(TEXTURE, barX, barY, 0, 9, (int)(60.0f * warpCompletionPercent + 2.0f), 9);
        String remainingTimeString = HomeboundUtil.timeFromTicks((1.0f - warpCompletionPercent) * (float)totalWarpDurationInTicks, 1);
        Font font = gui.m_93082_();
        int countdownTextX = barX + (64 - font.m_92895_(remainingTimeString)) / 2;
        Objects.requireNonNull(font);
        int countdownTextY = barY + 4 - 9 / 2 + 1;
        guiHelper.m_280488_(font, remainingTimeString, countdownTextX, countdownTextY, 0xFFFFFF);
        String bindHomeText = "Binding Home";
        int bindHomeTextX = barX + (64 - font.m_92895_(bindHomeText)) / 2;
        Objects.requireNonNull(font);
        int bindHomeTextY = barY + 4 - 9 / 2 + 1;
        Objects.requireNonNull(font);
        guiHelper.m_280488_(font, bindHomeText, bindHomeTextX, bindHomeTextY - 9 - 2, 0xFFFFFF);
    }
}

