/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.client.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.silvertide.homebound.client.gui.ClientWarpData;
import net.silvertide.homebound.util.HomeboundUtil;

public class WarpBarOverlay
implements IGuiOverlay {
    private static final WarpBarOverlay instance = new WarpBarOverlay();
    public static final ResourceLocation TEXTURE = new ResourceLocation("homebound", "textures/gui/warp_bars.png");
    static final int IMAGE_WIDTH = 64;
    static final int IMAGE_HEIGHT = 9;
    static final int COMPLETION_BAR_WIDTH = 60;

    public static WarpBarOverlay get() {
        return instance;
    }

    public void render(ForgeGui gui, GuiGraphics guiHelper, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!ClientWarpData.isPlayerWarping() || minecraft.f_91073_ == null) {
            return;
        }
        long currentGameTime = minecraft.f_91073_.m_46467_();
        long totalWarpDurationInTicks = ClientWarpData.getFinishWarpTimeStamp() - ClientWarpData.getStartWarpTimeStamp();
        float warpCompletionPercent = (float)(currentGameTime - ClientWarpData.getStartWarpTimeStamp()) / (float)totalWarpDurationInTicks;
        int barX = screenWidth / 2 - 32;
        int barY = screenHeight / 2 + screenHeight / 6;
        this.renderBarBackground(guiHelper, barX, barY);
        this.renderBarProgress(guiHelper, barX, barY, warpCompletionPercent);
        String remainingTimeString = HomeboundUtil.timeFromTicks((1.0f - warpCompletionPercent) * (float)totalWarpDurationInTicks, 1);
        Font font = gui.m_93082_();
        int countdownTextX = barX + (64 - font.m_92895_(remainingTimeString)) / 2;
        Objects.requireNonNull(font);
        int countdownTextY = barY + 4 - 9 / 2 + 1;
        guiHelper.m_280488_(font, remainingTimeString, countdownTextX, countdownTextY, 0xFFFFFF);
        String warpHomeText = "Returning Home";
        int warpHomeTextX = barX + (64 - font.m_92895_(warpHomeText)) / 2;
        Objects.requireNonNull(font);
        int warpHomeTextY = barY + 4 - 9 / 2 + 1;
        Objects.requireNonNull(font);
        guiHelper.m_280488_(font, warpHomeText, warpHomeTextX, warpHomeTextY - 9 - 2, 0xFFFFFF);
    }

    private void renderBarBackground(GuiGraphics guiHelper, int x, int y) {
        guiHelper.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, 64, 9, 256, 256);
    }

    private void renderBarProgress(GuiGraphics guiHelper, int x, int y, float warpCompletionPercent) {
        guiHelper.m_280218_(TEXTURE, x, y, 0, 18, (int)(60.0f * warpCompletionPercent + 2.0f), 9);
    }
}

