/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.events;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silvertide.homebound.item.ISoulboundItem;

@Mod.EventBusSubscriber(modid="homebound", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoulboundEvents {
    public static final String HOMEBOUND_INV_TAG = "HomeboundStoneInventory";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDeath(LivingDeathEvent livingDeathEvent) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = livingDeathEvent.getEntity();
                if (livingDeathEvent.getEntity().m_9236_().m_5776_() || livingDeathEvent.isCanceled() || !(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!(livingEntity instanceof FakePlayer) && !player.m_7500_() && !player.m_5833_()) break block5;
            }
            return;
        }
        if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            SoulboundEvents.keepSoulboundItems(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!event.isEndConquered()) {
            SoulboundEvents.returnStoredItems((Player)serverPlayer);
        }
    }

    private static void keepSoulboundItems(Player player) {
        ISoulboundItem soulboundItem;
        Inventory keepInventory = new Inventory(null);
        ListTag tagList = new ListTag();
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ISoulboundItem soulboundItem2;
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            Item item = stack.m_41720_();
            if (!(item instanceof ISoulboundItem) || !(soulboundItem2 = (ISoulboundItem)item).isSoulbound()) continue;
            keepInventory.f_35974_.set(i, (Object)stack.m_41777_());
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        Item item = ((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_();
        if (item instanceof ISoulboundItem && (soulboundItem = (ISoulboundItem)item).isSoulbound()) {
            keepInventory.f_35976_.set(0, (Object)((ItemStack)player.m_150109_().f_35976_.get(0)).m_41777_());
            player.m_150109_().f_35976_.set(0, (Object)ItemStack.f_41583_);
        }
        if (!keepInventory.m_7983_()) {
            keepInventory.m_36026_(tagList);
            SoulboundEvents.getPlayerData(player).m_128365_(HOMEBOUND_INV_TAG, (Tag)tagList);
        }
    }

    private static void returnStoredItems(Player player) {
        CompoundTag playerData = SoulboundEvents.getPlayerData(player);
        if (!player.m_9236_().m_5776_() && playerData.m_128441_(HOMEBOUND_INV_TAG)) {
            ListTag tagList = playerData.m_128437_(HOMEBOUND_INV_TAG, 10);
            SoulboundEvents.loadNoClear(tagList, player.m_150109_());
            SoulboundEvents.getPlayerData(player).m_128437_(HOMEBOUND_INV_TAG, 10).clear();
            SoulboundEvents.getPlayerData(player).m_128473_(HOMEBOUND_INV_TAG);
        }
    }

    private static void loadNoClear(ListTag tag, Inventory inventory) {
        ArrayList<ItemStack> blockedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag compoundtag = tag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (itemstack.m_41619_()) continue;
            if (j < inventory.f_35974_.size()) {
                if (((ItemStack)inventory.f_35974_.get(j)).m_41619_()) {
                    inventory.f_35974_.set(j, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j >= 100 && j < inventory.f_35975_.size() + 100) {
                if (((ItemStack)inventory.f_35975_.get(j - 100)).m_41619_()) {
                    inventory.f_35975_.set(j - 100, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j < 150 || j >= inventory.f_35976_.size() + 150) continue;
            if (((ItemStack)inventory.f_35976_.get(j - 150)).m_41619_()) {
                inventory.f_35976_.set(j - 150, (Object)itemstack);
                continue;
            }
            blockedItems.add(itemstack);
        }
        if (!blockedItems.isEmpty()) {
            blockedItems.forEach(arg_0 -> ((Inventory)inventory).m_36054_(arg_0));
        }
    }

    public static CompoundTag getPlayerData(Player player) {
        if (!player.getPersistentData().m_128441_("PlayerPersisted")) {
            player.getPersistentData().m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return player.getPersistentData().m_128469_("PlayerPersisted");
    }
}

