/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.events;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silvertide.homebound.config.Config;
import net.silvertide.homebound.data.ScheduledBindHome;
import net.silvertide.homebound.data.ScheduledWarp;
import net.silvertide.homebound.data.WarpResult;
import net.silvertide.homebound.events.custom.StartWarpEvent;
import net.silvertide.homebound.item.HomeWarpItem;
import net.silvertide.homebound.services.HomeManager;
import net.silvertide.homebound.services.WarpManager;
import net.silvertide.homebound.util.CapabilityUtil;
import net.silvertide.homebound.util.HomeboundUtil;

@Mod.EventBusSubscriber(modid="homebound", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WarpEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if ((Integer)Config.HURT_COOLDOWN_TIME.get() > 0 && WarpManager.get().isPlayerWarping(player)) {
                WarpManager.get().cancelWarp(player);
                if (player.m_6117_() && player.m_21211_().m_41720_() instanceof HomeWarpItem) {
                    player.m_5810_();
                }
                CapabilityUtil.getWarpCap((LivingEntity)player).ifPresent(warpCap -> {
                    long gameTime = player.m_9236_().m_46467_();
                    if (!warpCap.hasCooldown(gameTime)) {
                        warpCap.setCooldown(gameTime, (Integer)Config.HURT_COOLDOWN_TIME.get());
                    }
                });
                HomeboundUtil.displayClientMessage((Player)player, "Warp cancelled from taking damage.");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.haveTime() && event.phase == TickEvent.Phase.END) {
            if (WarpManager.get().warpIsActive()) {
                WarpManager warpManager = WarpManager.get();
                List<ScheduledWarp> scheduledWarpAttributes = warpManager.getWarpAttributeList();
                scheduledWarpAttributes.forEach(warp -> {
                    ServerPlayer serverPlayer = warp.serverPlayer();
                    if (warpManager.warpPercentComplete(serverPlayer) >= 100.0) {
                        warpManager.warpPlayerHome(serverPlayer);
                    } else if (serverPlayer.m_9236_().m_46467_() % 10L == 0L) {
                        warpManager.playWarpEffects(serverPlayer);
                    }
                });
            }
            if (HomeManager.get().bindHomeIsActive()) {
                HomeManager homeManager = HomeManager.get();
                List<ScheduledBindHome> scheduledHomeBinds = homeManager.getBindHomeSchedules();
                scheduledHomeBinds.forEach(homeBind -> {
                    ServerPlayer serverPlayer = homeBind.serverPlayer();
                    if (homeManager.bindHomePercentComplete(serverPlayer) >= 100.0) {
                        homeManager.setPlayerHome(serverPlayer);
                        homeManager.triggerHomeBindEffects(serverPlayer);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onStartWarp(StartWarpEvent warpEvent) {
        if (warpEvent.isCanceled()) {
            return;
        }
        Player player = warpEvent.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WarpResult warpResult = WarpManager.get().canPlayerWarp(serverPlayer, warpEvent.getWarpItem());
            if (!warpResult.success()) {
                warpEvent.setCanceled(true);
                HomeboundUtil.displayClientMessage((Player)serverPlayer, warpResult.message());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent loggedOutEvent) {
        Player player = loggedOutEvent.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (WarpManager.get().isPlayerWarping(serverPlayer)) {
                WarpManager.get().cancelWarp(serverPlayer);
            }
            if (HomeManager.get().isPlayerBindingHome(serverPlayer)) {
                HomeManager.get().cancelBindHome(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent livingDeathEvent) {
        LivingEntity livingEntity;
        if (!livingDeathEvent.getEntity().m_9236_().m_5776_() && (livingEntity = livingDeathEvent.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (WarpManager.get().isPlayerWarping(serverPlayer)) {
                WarpManager.get().cancelWarp(serverPlayer);
            }
            if (HomeManager.get().isPlayerBindingHome(serverPlayer)) {
                HomeManager.get().cancelBindHome(serverPlayer);
            }
        }
    }
}

