/*
 * Decompiled with CFR 0.152.
 */
package net.silvertide.homebound.item;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silvertide.homebound.config.Config;
import net.silvertide.homebound.events.custom.StartWarpEvent;
import net.silvertide.homebound.item.HomeWarpItemId;
import net.silvertide.homebound.item.ISoulboundItem;
import net.silvertide.homebound.item.IWarpItem;
import net.silvertide.homebound.services.HomeManager;
import net.silvertide.homebound.services.WarpManager;
import net.silvertide.homebound.util.CapabilityUtil;
import net.silvertide.homebound.util.EnchantmentUtil;
import net.silvertide.homebound.util.HomeboundUtil;
import org.jetbrains.annotations.Nullable;

public class HomeWarpItem
extends Item
implements ISoulboundItem,
IWarpItem {
    protected HomeWarpItemId id;
    private final boolean soulbound;
    private final boolean isEnchantable;
    private final int enchantability;

    public HomeWarpItem(HomeWarpItemId id, Properties properties) {
        super(new Item.Properties().m_41487_(1).m_41497_(properties.rarity));
        this.id = id;
        this.soulbound = properties.soulbound;
        this.isEnchantable = properties.isEnchantable;
        this.enchantability = properties.enchantability;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pUsedHand) {
        ItemStack stack = player.m_21120_(pUsedHand);
        if (!level.m_5776_()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_6047_()) {
                HomeManager homeManager = HomeManager.get();
                if (!homeManager.isPlayerBindingHome(serverPlayer) && homeManager.canPlayerSetHome(serverPlayer)) {
                    homeManager.startBindingHome(serverPlayer);
                    player.m_6672_(pUsedHand);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            WarpManager warpManager = WarpManager.get();
            if (!warpManager.isPlayerWarping(serverPlayer) && !MinecraftForge.EVENT_BUS.post((Event)new StartWarpEvent(player, this))) {
                warpManager.startWarping(serverPlayer, stack);
                player.m_6672_(pUsedHand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!level.m_5776_() && entity instanceof ServerPlayer) {
            HomeManager homeManager;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            WarpManager warpManager = WarpManager.get();
            if (warpManager.isPlayerWarping(serverPlayer)) {
                warpManager.cancelWarp(serverPlayer);
            }
            if ((homeManager = HomeManager.get()).isPlayerBindingHome(serverPlayer)) {
                homeManager.cancelBindHome(serverPlayer);
            }
            if (CapabilityUtil.getRemainingCooldown((Player)serverPlayer) < 1) {
                CapabilityUtil.getWarpCap((LivingEntity)serverPlayer).ifPresent(warpCap -> warpCap.setCooldown(serverPlayer.m_9236_().m_46467_(), 1));
            }
        }
    }

    @Override
    public int getWarpUseDuration(ItemStack stack) {
        int useDuration = this.getBaseUseDurationInTicks();
        return EnchantmentUtil.applyEnchantHasteModifier(useDuration, EnchantmentUtil.getHasteEnchantLevel(stack));
    }

    @Override
    public int getWarpCooldown(ServerPlayer player, ItemStack stack) {
        int baseCooldown = this.getBaseCooldown();
        return EnchantmentUtil.applyEnchantCooldownModifier(HomeboundUtil.applyDistanceCooldownModifier(this, player, baseCooldown), EnchantmentUtil.getCooldownEnchantLevel(stack));
    }

    @Override
    public boolean isConsumedOnUse() {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_8120_(ItemStack stack) {
        return this.isEnchantable;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.isEnchantable ? this.enchantability : 0;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    protected void addCooldownHoverText(List<Component> pTooltipComponents, ItemStack stack) {
        double distanceBasedCooldownReduction = this.getDistanceBasedCooldownReduction();
        int cooldown = EnchantmentUtil.applyEnchantCooldownModifier(this.getBaseCooldown(), EnchantmentUtil.getCooldownEnchantLevel(stack));
        if (distanceBasedCooldownReduction > 0.0) {
            int blocksPerPercentReduced = this.getBlocksPerBonusReducedBy1Percent();
            double lowestCooldownPossible = (double)cooldown * (1.0 - distanceBasedCooldownReduction);
            pTooltipComponents.add((Component)Component.m_237113_((String)("Cooldown is reduced by as much as \u00a7a" + distanceBasedCooldownReduction * 100.0 + "%\u00a7r when close to home.")));
            pTooltipComponents.add((Component)Component.m_237113_((String)("This bonus is reduced by \u00a7a1%\u00a7r for every " + blocksPerPercentReduced + " blocks away from home.")));
            pTooltipComponents.add((Component)Component.m_237113_((String)"Traveling across dimensions doubles this penalty."));
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a7aCooldown: " + HomeboundUtil.formatTime((int)lowestCooldownPossible) + " (less than " + blocksPerPercentReduced + " blocks) to " + HomeboundUtil.formatTime(cooldown) + " (over " + (int)(distanceBasedCooldownReduction * 100.0 * (double)blocksPerPercentReduced) + " blocks)\u00a7r")));
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a7aCooldown: " + HomeboundUtil.formatTime(cooldown) + "\u00a7r")));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            boolean canDimTravel;
            pTooltipComponents.add((Component)Component.m_237113_((String)"Crouch and use the item to set your home."));
            this.addCooldownHoverText(pTooltipComponents, stack);
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a7aCast Time: " + (double)this.getWarpUseDuration(stack) / 20.0 + " seconds.\u00a7r")));
            int maxDistance = this.getMaxDistance();
            if (maxDistance > 0) {
                pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a7aMax Distance: " + maxDistance + " blocks\u00a7r")));
            }
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a7aDimensional Travel: " + ((canDimTravel = this.canDimTravel()) ? "Yes" : "\u00a7cNo\u00a7r") + "\u00a7r")));
            if (this.isSoulbound()) {
                pTooltipComponents.add((Component)Component.m_237113_((String)"\u00a75This item persists death.\u00a7r"));
            }
        } else {
            pTooltipComponents.add((Component)Component.m_237113_((String)"Find your way home. Press \u00a7eSHIFT\u00a7r for more info."));
        }
        super.m_7373_(stack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public boolean isSoulbound() {
        return this.soulbound;
    }

    @Override
    public int getBaseCooldown() {
        int cooldownInMinutes = switch (this.id) {
            case HomeWarpItemId.HOMEWARD_BONE -> (Integer)Config.HOMEWARD_BONE_COOLDOWN.get();
            case HomeWarpItemId.HEARTHWOOD -> (Integer)Config.HEARTHWOOD_COOLDOWN.get();
            case HomeWarpItemId.HOMEWARD_GEM -> (Integer)Config.HOMEWARD_GEM_COOLDOWN.get();
            case HomeWarpItemId.HOMEWARD_STONE -> (Integer)Config.HOMEWARD_STONE_COOLDOWN.get();
            case HomeWarpItemId.HAVEN_STONE -> (Integer)Config.HAVEN_STONE_COOLDOWN.get();
            case HomeWarpItemId.DAWN_STONE -> (Integer)Config.DAWN_STONE_COOLDOWN.get();
            case HomeWarpItemId.SUN_STONE -> (Integer)Config.SUN_STONE_COOLDOWN.get();
            case HomeWarpItemId.DUSK_STONE -> (Integer)Config.DUSK_STONE_COOLDOWN.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Integer)Config.TWILIGHT_STONE_COOLDOWN.get();
            default -> 60;
        };
        return cooldownInMinutes * 60;
    }

    @Override
    public double getDistanceBasedCooldownReduction() {
        return switch (this.id) {
            case HomeWarpItemId.DUSK_STONE -> (Double)Config.DUSK_STONE_MAX_DISTANCE_REDUCTION.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Double)Config.TWILIGHT_STONE_MAX_DISTANCE_REDUCTION.get();
            default -> 0.0;
        };
    }

    @Override
    public int getBlocksPerBonusReducedBy1Percent() {
        return switch (this.id) {
            case HomeWarpItemId.DUSK_STONE -> (Integer)Config.DUSK_STONE_BLOCKS_PER_BONUS_REDUCED_BY_ONE_PERCENT.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Integer)Config.TWILIGHT_STONE_BLOCKS_PER_BONUS_REDUCED_BY_ONE_PERCENT.get();
            default -> 0;
        };
    }

    @Override
    public int getBaseUseDurationInTicks() {
        int useDurationInSeconds = switch (this.id) {
            case HomeWarpItemId.HOMEWARD_BONE -> (Integer)Config.HOMEWARD_BONE_USE_TIME.get();
            case HomeWarpItemId.HEARTHWOOD -> (Integer)Config.HEARTHWOOD_USE_TIME.get();
            case HomeWarpItemId.HOMEWARD_GEM -> (Integer)Config.HOMEWARD_GEM_USE_TIME.get();
            case HomeWarpItemId.HOMEWARD_STONE -> (Integer)Config.HOMEWARD_STONE_USE_TIME.get();
            case HomeWarpItemId.HAVEN_STONE -> (Integer)Config.HAVEN_STONE_USE_TIME.get();
            case HomeWarpItemId.DAWN_STONE -> (Integer)Config.DAWN_STONE_USE_TIME.get();
            case HomeWarpItemId.SUN_STONE -> (Integer)Config.SUN_STONE_USE_TIME.get();
            case HomeWarpItemId.DUSK_STONE -> (Integer)Config.DUSK_STONE_USE_TIME.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Integer)Config.TWILIGHT_STONE_USE_TIME.get();
            default -> 10;
        };
        return useDurationInSeconds * 20;
    }

    @Override
    public boolean canDimTravel() {
        return switch (this.id) {
            case HomeWarpItemId.HOMEWARD_BONE -> (Boolean)Config.HOMEWARD_BONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.HEARTHWOOD -> (Boolean)Config.HEARTHWOOD_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.HOMEWARD_GEM -> (Boolean)Config.HOMEWARD_GEM_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.HOMEWARD_STONE -> (Boolean)Config.HOMEWARD_STONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.HAVEN_STONE -> (Boolean)Config.HAVEN_STONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.DAWN_STONE -> (Boolean)Config.DAWN_STONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.SUN_STONE -> (Boolean)Config.SUN_STONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.DUSK_STONE -> (Boolean)Config.DUSK_STONE_DIMENSIONAL_TRAVEL.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Boolean)Config.TWILIGHT_STONE_DIMENSIONAL_TRAVEL.get();
            default -> false;
        };
    }

    @Override
    public int getMaxDistance() {
        return switch (this.id) {
            case HomeWarpItemId.HOMEWARD_BONE -> (Integer)Config.HOMEWARD_BONE_MAX_DISTANCE.get();
            case HomeWarpItemId.HEARTHWOOD -> (Integer)Config.HEARTHWOOD_MAX_DISTANCE.get();
            case HomeWarpItemId.HOMEWARD_GEM -> (Integer)Config.HOMEWARD_GEM_MAX_DISTANCE.get();
            case HomeWarpItemId.HOMEWARD_STONE -> (Integer)Config.HOMEWARD_STONE_MAX_DISTANCE.get();
            case HomeWarpItemId.HAVEN_STONE -> (Integer)Config.HAVEN_STONE_MAX_DISTANCE.get();
            case HomeWarpItemId.DAWN_STONE -> (Integer)Config.DAWN_STONE_MAX_DISTANCE.get();
            case HomeWarpItemId.SUN_STONE -> (Integer)Config.SUN_STONE_MAX_DISTANCE.get();
            case HomeWarpItemId.DUSK_STONE -> (Integer)Config.DUSK_STONE_MAX_DISTANCE.get();
            case HomeWarpItemId.TWILIGHT_STONE -> (Integer)Config.TWILIGHT_STONE_MAX_DISTANCE.get();
            default -> 0;
        };
    }

    public static class Properties {
        Rarity rarity = Rarity.COMMON;
        boolean soulbound = false;
        boolean isEnchantable = true;
        int enchantability = 15;

        public Properties isSoulbound(boolean isSoulbound) {
            this.soulbound = isSoulbound;
            return this;
        }

        public Properties rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Properties isEnchantable(boolean isEnchantable) {
            this.isEnchantable = isEnchantable;
            return this;
        }

        public Properties enchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }
    }
}

